C
C
      SUBROUTINE G08AEF$(X, IX, K, N, W1, W2, FR, P, IFAIL)
C
C ACTION : Friedman test
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 28/4/97
C          20/04/2004 revised
C          IFAIL is not tested on entry so it is like IFAIL = 1
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    IFAIL, IX, K, N
      DOUBLE PRECISION FR, P, W1(K), W2(K), X(IX,N)
C
C Local variables
C
      INTEGER    ISEND, N0, N1, N2, N3
      PARAMETER (ISEND = 0, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, J, NDOF
      DOUBLE PRECISION ZERO, ONE, TWO, F12
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F12 = 12.0D+00)
      DOUBLE PRECISION SSW, WMEAN, WW, XF
      DOUBLE PRECISION G01ECF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      EXTERNAL   G01ECF$
      EXTERNAL   RANKIT
      INTRINSIC  DBLE
C
C Is it safe ?
C
      IFAIL = N0
      IF (N.LT.N1) THEN
         IFAIL = N1
         RETURN
      ELSEIF (IX.LT.K) THEN
         IFAIL = N2
         RETURN
      ELSEIF (K.LT.N2) THEN
         IFAIL = N3
         RETURN
      ENDIF
C
C Get the first set of ranks
C
      CALL RANKIT (ISEND, K, X(N1,N1), XF, W2)
C
C Get the other ranks and add them on
C
      IF (N.GT.N1) THEN
         DO J = N2, N
            CALL RANKIT (ISEND, K, X(N1,J), XF, W1)
            DO I = N1, K
               W2(I) = W2(I) + W1(I)
            ENDDO
         ENDDO
      ENDIF
C
C Work out sum of squares then the Friedman statistic
C
      SSW = ZERO
      WMEAN = DBLE(N*(K + N1))/TWO
      DO I = N1, K
         WW = W2(I) - WMEAN
         SSW = SSW + WW*WW
      ENDDO
      FR = F12*SSW/DBLE(N*K*(K + N1))
C
C Now get the approximate significance level
C
      NDOF = K - N1
      I = N1
      P = G01ECF$(TAIL, FR, DBLE(NDOF), I)
      IF (P.GT.ONE) THEN
         P = ONE
      ELSEIF (P.LT.ZERO) THEN
         P = ZERO
      ENDIF
      END
C
C

