C
C
      SUBROUTINE G08AFF$(X, L, LX, K, W, H, P, IFAIL)
C
C ACTION : Kruskal wallis test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/4/97
C          20/04/2004 revised
C          IFAIL is not tested on entry so it is like IFAIL = 1
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    IFAIL, K, L, LX(K)
      DOUBLE PRECISION H, P, W(L), X(L)
C
C Local variables
C
      INTEGER    ISEND, N0, N1, N2, N3, N4
      PARAMETER (ISEND = 1, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, I1, J, L1, L2, LSUM, NDOF
      DOUBLE PRECISION ZERO, ONE, THREE, F12
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, THREE = 3.0D+00,
     +           F12 = 12.0D+00)
      DOUBLE PRECISION DENOM, DL, RJ, RS1, T, XI, X1
      DOUBLE PRECISION G01ECF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      LOGICAL    EQUAL
      EXTERNAL   G01ECF$
      EXTERNAL   RANKIT
      INTRINSIC  DBLE
C
C Is it safe ?
C
      IFAIL = N0
      IF (K.LT.N2) THEN
         IFAIL = N2
         RETURN
      ENDIF
      LSUM = N0
      DO I = N1, K
         IF (LX(I).LE.N0) THEN
            IFAIL = N2
            RETURN
         ENDIF
         LSUM = LSUM + LX(I)
      ENDDO
      IF (LSUM.NE.L) THEN
         IFAIL = N3
         RETURN
      ENDIF
C
C Are all the values equal ?
C
      EQUAL = .TRUE.
      X1 = X(N1)
      DO I = N2, L
         IF (EQUAL) THEN
            XI = X(I)
            IF (XI.LT.X1 .OR. XI.GT.X1) EQUAL = .FALSE.
         ENDIF
      ENDDO
      IF (EQUAL) THEN
         IFAIL = N4
         RETURN
      ENDIF
C
C Data is OK so now calculate the ranks and the statistic
C
      CALL RANKIT (ISEND, L, X, T, W)
      RS1 = ZERO
      DO I = N1, K
         L1 = N1
         IF (I.NE.N1) THEN
            I1 = I - N1
            DO J = N1, I1
               L1 = L1 + LX(J)
            ENDDO
         ENDIF
         L2 = L1 + LX(I) - N1
         RJ = ZERO
         DO J = L1, L2
            RJ = RJ + W(J)
         ENDDO
         DL = DBLE(LX(I))
         RJ = RJ*RJ/DL
         RS1 = RS1 + RJ
      ENDDO
      DL = DBLE(L)
      H = F12*RS1/(DL*(DL + ONE)) - THREE*(DL + ONE)
C
C Correct for ties if required
C
      IF (T.GT.ZERO) THEN
         DENOM = ONE - F12*T/(DL*DL*DL - DL)
         IF (DENOM.LE.ZERO) THEN
            IFAIL = N4
            RETURN
         ENDIF
         H = H/DENOM
      ENDIF
C
C Get the approximate chi-square value
C
      NDOF = K - N1
      I = N1
      P = G01ECF$(TAIL, H, DBLE(NDOF), I)
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C
