C
C
      SUBROUTINE G08AGF$(N, X, XME, TAIL, ZEROS, W, WNOR, P, N1,
     +                   WRK, IFAIL)
C
C ACTION : MWU test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 20/04/2004
C          15/01/2006 introduced allocatable arrays
C          20/08/2007 corrected error from not storing WRK(2*N + I) = WRK(N + I)
C           
C          This version does not test IFAIL on entry so it is like IFAIL = 1
C          Identical results are returned as for the NAG routine unless there
C          are zeros when differences are probably due to the use of the
C          Pratt procedure (Zar 3rd edition page 170) in this routine.
C          IFAIL is returned as IFAIL = 10 if failure to allocate workspace
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IFAIL, N, N1
      DOUBLE PRECISION X(N), XME, W, WNOR, P, WRK(3*N)
      CHARACTER TAIL*(*), ZEROS*1 
C
C Local allocatable workspaces
C  
      INTEGER, ALLOCATABLE :: IRANK(:)
      DOUBLE PRECISION, ALLOCATABLE :: CDF(:)    
C
C Local variables
C
      INTEGER    ISEND, K0, K1, K2, K3
      PARAMETER (ISEND = 1, K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    NMAX, NMCDF
      PARAMETER (NMAX = 80, NMCDF = NMAX*(NMAX + 1)/2)
      INTEGER    IHIGH, ISHIFT, IUPPER
      INTEGER    I, IERR, IFSAV, J, M, MP, M2, N2, N12
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, FOUR, F24
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, FOUR = 4.0D+00, F24 = 24.0D+00)
      DOUBLE PRECISION PROB, SIGMA, TEMP, TMINUS, TPLUS, TS, VAR
      DOUBLE PRECISION S15ABF$
      CHARACTER  C*1, Z*1
      LOGICAL    EQUAL
      EXTERNAL   S15ABF$
      EXTERNAL   RANKIT
      INTRINSIC  DBLE, MIN, SQRT, NINT
C
C Is it safe ?
C
      IFAIL = K0
      W = ZERO
      WNOR = ZERO
      P = ZERO
      N1 = K0
      IF (N.LT.K1) THEN
         IFAIL = K2
         RETURN
      ENDIF
      C = TAIL(K1:K1)
      IF (C.EQ.'t') THEN
         C = 'T'
      ELSEIF (C.EQ.'u') THEN
         C = 'U'
      ELSEIF (C.EQ.'l') THEN
         C = 'L'
      ENDIF
      IF (C.NE.'T' .AND. C.NE.'U' .AND. C.NE.'L') THEN
         IFAIL = K1
         RETURN
      ENDIF
      Z = ZEROS(K1:K1)
      IF (Z.EQ.'y') THEN
         Z = 'Y'
      ELSEIF (Z.EQ.'n') THEN
         Z = 'N'
      ENDIF
      IF (Z.NE.'Y' .AND. Z.NE.'N') THEN
         IFAIL = N1
         RETURN
      ENDIF               
C
C Allocate workspace
C                           
      IERR = 0    
      IFSAV = IFAIL
      IFAIL = 10
      IF (ALLOCATED(IRANK)) DEALLOCATE(IRANK, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(CDF)) DEALLOCATE(CDF, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IRANK(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(CDF(0:NMCDF), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Are all values equal ?
C
      EQUAL = .TRUE.
      MP = K0
      N1 = K0
C
C partitioning of WRK (if zeros are omitted then eventually replace N by N1)
C ===================
C WRK(1)       to WRK(N)   = ABS(X(I) - XME)
C WRK(N + 1)   to WRK(2*N) = -1.0 if X(I) < XME, 0 IF X(I) = XME, 1.0 IF X(I) > XME
C WRK(2*N + 1) to WRK(3*N) = first used to store WRK(N + I) then used for RANKS
C Now check for equality and work out MP and N1
C
      N2 = K2*N
      DO I = K1, N
         WRK(I) = X(I) - XME
         IF (WRK(I).LT.ZERO) THEN
C
C Reverse the sign before ranking but store the sign as -1.0
C
            EQUAL = .FALSE.
            N1 = N1 + K1
            WRK(I) = - WRK(I)
            WRK(N + I) = - ONE
         ELSEIF (WRK(I).GT.ZERO) THEN
C
C Store as is for ranking with sign = 1.0
C
            EQUAL = .FALSE.
            N1 = N1 + K1
            WRK(N + I) = ONE
         ELSE
C
C Indicate a zero by incrementing MP and storing the sign as sign = 0.0
C
            MP = MP + K1
            WRK(N + I) = ZERO
         ENDIF
C
C Store WRK(N + I) in WRK(2*N + I) in case shuffling is required i.e., Z = 'N'
C         
         WRK(N2 + I) = WRK(N + I)
      ENDDO
      IF (EQUAL) THEN
         IFAIL = K3      
         DEALLOCATE(IRANK, STAT = IERR)
         DEALLOCATE(CDF, STAT = IERR)
         RETURN
      ENDIF
C
C The data seem OK so proceed
C
      IF (Z.EQ.'Y') THEN
C
C Include the zeros if any
C
         M = N
      ELSE
C
C Restore MP and shuffle if there are any zeros
C
         MP = K0
         IF (N1.EQ.N) THEN
            M = N
         ELSE
            M = K0
            N2 = K2*N
            DO I = K1, N
               TEMP = WRK(N2 + I)
               IF (TEMP.LT.ZERO .OR. TEMP.GT.ZERO) THEN
                  M = M + K1
                  WRK(M) = WRK(I)
               ENDIF
            ENDDO
            M = K0
            DO I = K1, N
               TEMP = WRK(N2 + I)
               IF (TEMP.LT.ZERO .OR. TEMP.GT.ZERO) THEN
                  M = M + K1
                  WRK(N1 + M) = WRK(N + I)
               ENDIF
            ENDDO
            M = K0
            N12 = K2*N1
            DO I = K1, N
               TEMP = WRK(N2 + I)
               IF (TEMP.LT.ZERO .OR. TEMP.GT.ZERO) THEN
                  M = M + K1
                  WRK(N12 + M) = WRK(N2 + I)
               ENDIF
            ENDDO
            M = N1
         ENDIF
      ENDIF
      IF (M.LT.K1) THEN
C
C Error if no effective data left
C
         IFAIL = K2 
         DEALLOCATE(IRANK, STAT = IERR)
         DEALLOCATE(CDF, STAT = IERR)
         RETURN
      ENDIF
C
C Rank the absolute values
C
      M2 = K2*M
      CALL RANKIT (ISEND, M, WRK, TS, WRK(M2 + K1))
C
C Calculate W
C
      W = ZERO
      DO I = K1, M
         TEMP = WRK(M + I)
         IF (TEMP.GT.ZERO) W = W + WRK(M2 + I)
      ENDDO
C
C Calculate the normal statistic
C
C ....The standard formula for the variance
      VAR = DBLE(M*(M + K1)*(M2 + K1))/F24
C ....Correct for ties
      VAR = VAR - TS/FOUR
      IF (MP.GT.K0) THEN
C ....Correct for zeros
         VAR = VAR - DBLE(MP*(MP + K1)*(K2*MP + K1))
C ....Correct for overuse of ties if there are zeros
         VAR = VAR + DBLE(MP*(MP*MP - K1))/(TWO*F24)
      ENDIF
      IF (VAR.GT.ZERO) THEN
C ....The standard formula for the denominator and numerator
         SIGMA = SQRT(VAR)
         TEMP = W - DBLE(M*(M + K1))/FOUR
C ....Correct for zeros
         IF (MP.GT.K0) TEMP = TEMP - DBLE(MP*(MP + K1))/FOUR
C ....Continuity correction
         IF (TEMP.GE.ZERO) THEN
            WNOR = (TEMP - HALF)/SIGMA
         ELSE
            WNOR = (TEMP + HALF)/SIGMA
         ENDIF
      ELSE
         WNOR = ZERO
      ENDIF
C
C Work out P
C
      IF (M.GT.NMAX) THEN
C
C Use the normal approximation
C
         I = K1
         PROB = S15ABF$(WNOR, I)
         IF (C.EQ.'L') THEN
            P = PROB
         ELSEIF (C.EQ.'U') THEN
            P = ONE - PROB
         ELSE
            P = TWO*MIN(PROB, ONE - PROB)
         ENDIF
      ELSE
C
C Use Neumanns method
C
         DO I = K1, M
            IRANK(I) = NINT(WRK(M2 + I))
         ENDDO
         IHIGH = K0
         DO I = K1, M
            IHIGH = IHIGH + IRANK(I)
         ENDDO
         DO I = K0, IHIGH
            CDF(I) = ONE
         ENDDO
         IUPPER = K0
         DO I = K1, M
            ISHIFT = IRANK(I)
            IUPPER = IUPPER + ISHIFT
            DO J = IUPPER, K0, -K1
               CDF(J) = HALF*CDF(J)
               IF (ISHIFT.LE.J) CDF(J) = CDF(J) + HALF*CDF(J - ISHIFT)
            ENDDO
         ENDDO
         J = M*(M + K1)/K2
         TPLUS = W
         TMINUS = DBLE(J) - W
         IF (C.EQ.'L') THEN
            I = NINT(TPLUS)
            P = CDF(I)
         ELSEIF (C.EQ.'U') THEN
            I = NINT(TMINUS)
            P = CDF(I)
         ELSE
            IF (TMINUS.LT.TPLUS) THEN
               I = NINT(TMINUS)
            ELSE
               I = NINT(TPLUS)
            ENDIF
            PROB = CDF(I)
            P = TWO*PROB
         ENDIF
      ENDIF
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF                 
C
C Deallocate workspace
C  
      DEALLOCATE(IRANK, STAT = IERR)
      DEALLOCATE(CDF, STAT = IERR)
      END
C
C
