C
C
      SUBROUTINE G08AHF$(N1, X, N2, Y, TAIL, U, UNOR, P, TIES, RANKS,
     +                   WRK, IFAIL)
C
C ACTION : MWU test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/4/97
C          This version does not test IFAIL on entry so it is like IFAIL = 1
C          20/04/2004 revised
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    IFAIL, N1, N2
      DOUBLE PRECISION P, RANKS(N1 + N2), U, UNOR, WRK(N1 + N2), X(N1),
     +                 Y(N2)
      CHARACTER TAIL*(*)
      LOGICAL TIES
C
C Local variables
C
      INTEGER    ISEND, K0, K1, K2, K3
      PARAMETER (ISEND = 1, K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    I, J, N, NP
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, F12
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, F12 = 12.0D+00)
      DOUBLE PRECISION DN, DN1, DN2, PROB, RSUM, S, TS, WI, W1
      DOUBLE PRECISION UL, UNORL, UNORU, UU
      DOUBLE PRECISION S15ABF$
      CHARACTER  C*1
      LOGICAL    EQUAL
      EXTERNAL   S15ABF$
      EXTERNAL   RANKIT
      INTRINSIC  DBLE, MIN, SQRT
C
C Is it safe ?
C
      IFAIL = K0
      IF (N1.LT.K1 .OR. N2.LT.K1) THEN
         IFAIL = K1
         RETURN
      ENDIF
      C = TAIL(K1:K1)
      IF (C.EQ.'t') THEN
         C = 'T'
      ELSEIF (C.EQ.'u') THEN
         C = 'U'
      ELSEIF (C.EQ.'l') THEN
         C = 'L'
      ENDIF
      IF (C.NE.'T' .AND. C.NE.'U' .AND.C.NE.'L') THEN
         IFAIL = K2
         RETURN
      ENDIF
C
C Are all values equal ?
C
      DO I = K1, N1
         WRK(I) = X(I)
      ENDDO
      J = N1
      DO I = K1, N2
         J = J + 1
         WRK(J) = Y(I)
      ENDDO
      N = N1 + N2
      EQUAL = .TRUE.
      W1 = WRK(1)
      DO I = K2, N
         IF (EQUAL) THEN
            WI = WRK(I)
            IF (WI.LT.W1 .OR. WI.GT.W1) EQUAL = .FALSE.
         ENDIF
      ENDDO
      IF (EQUAL) THEN
         IFAIL = K3
         RETURN
      ENDIF
C
C The data seem OK so proceed
C
      CALL RANKIT (ISEND, N, WRK, TS, RANKS)
      RSUM = ZERO
      NP = N1 + K1
      DO I = NP, N
         RSUM = RSUM + RANKS(I)
      ENDDO
      DN = DBLE(N)
      DN1 = DBLE(N1)
      DN2 = DBLE(N2)
      U = DN1*DN2 + DN2*(DN2 + ONE)/TWO - RSUM
      IF (TS.GT.ZERO) THEN
         TIES = .TRUE.
         S = SQRT((DN1*DN2/(DN*(DN - ONE)))*(((DN*DN*DN - DN)/F12)
     +       - TS))
         IF (S.LE.ZERO) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ELSE
         TIES = .FALSE.
         S = SQRT(DN1*DN2*(DN + ONE)/F12)
      ENDIF
      UNOR = U - DN1*DN2*HALF
C
C Continuity correction for normal approximation
C
      IF (UNOR.LT.ZERO) THEN
         UNOR = (UNOR + HALF)/S
      ELSE
         UNOR = (UNOR - HALF)/S
      ENDIF
      I = K1
      IF (C.EQ.'U') THEN
C
C Upper tail test: reject H0 if p < alpha in favour of F(x) < G(y) i.e. x > y
C
         UU = DN1*DN2 - U
         UNORU = (UU - DN1*DN2*HALF + HALF)/S
         PROB = S15ABF$(UNORU, I)
         P = PROB
      ELSEIF (C.EQ.'L') THEN
C
C Lower tail test: reject H0 if p < alpha in favour of F(x) > G(y) i.e. x < y
C
         UL = U
         UNORL = (UL - DN1*DN2*HALF + HALF)/S
         PROB = S15ABF$(UNORL, I)
         P = PROB
      ELSE
C
C Two tail test statistic
C
         PROB = S15ABF$(UNOR, I)
         P = TWO*MIN(PROB, ONE - PROB)
      ENDIF
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C
