C
C
      SUBROUTINE G08AJF$(N1, N2, TAIL, U, P, WRK, LWRK, IFAIL)
C
C ACTION : Exact MWU p by Hardings method
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/5/97
C          20/04/2004 revised
C          Note: this version requires LWRK >= N1*N2 + 1 as it calculates
C                all the probablities by Harding/Neumann. It should be
C                re-worked at some stage to exploit symmetry in the
C                probabilities and reduce the workspace requirement to N1*N2/2 + 1
C          See Neumann N Stat Soft Newsletter 14, 3, 120-126 (1988)
C
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    IFAIL, LWRK, N1, N2
      DOUBLE PRECISION P, U, WRK(0:LWRK - 1)
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    K0, K1, K2, K3, K4
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4)
      INTEGER    I, J, M1, M2, NLOWER, NUPPER
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION BINOM
      CHARACTER  C1*1
      INTRINSIC  NINT
C
C Is it safe ?
C
      IFAIL = K0
      IF (N1.LT.K1 .OR. N2.LT.K1) THEN
         IFAIL = K1
         RETURN
      ENDIF
      C1 = TAIL(K1:K1)
      IF (C1.EQ.'T' .OR. C1.EQ.'t') THEN
         C1 = 'T'
      ELSEIF (C1.EQ.'U' .OR. C1.EQ.'u') THEN
         C1 = 'U'
      ELSEIF (C1.EQ.'L' .OR. C1.EQ.'l') THEN
         C1 = 'L'
      ELSE
         IFAIL = K2
         RETURN
      ENDIF
      IF (U.LT.ZERO) THEN
         IFAIL = K3
         RETURN
      ENDIF
C*****IF (LWRK.LT.(N1*N2)/2 + K1) THEN!NAG requirements
      IF (LWRK.LT.N1*N2 + K1) THEN    !requirements for this version
         IFAIL = K4
         RETURN
      ENDIF
C
C Copy N1 and N2 then work out all of the possible probabilities
C
      IF (N2.GE.N1) THEN
         M1 = N1
         M2 = N2
      ELSE
         M1 = N2
         M2 = N1
      ENDIF
      NUPPER = M1*M2
C
C Initialise
C
      BINOM = ONE
      WRK(K0) = ONE
      DO J = K1, NUPPER
         WRK(J) = ZERO
      ENDDO
C
C The main loop
C
      DO I = K1, M1
         BINOM = BINOM*DBLE(M2 + I)/DBLE(I)
         NUPPER = I*M2
         NLOWER = I + M2
         DO J = NUPPER, NLOWER, -K1
            WRK(J) = WRK(J) - WRK(J - NLOWER)
         ENDDO
         DO J = I, NUPPER
            WRK(J) = WRK(J) + WRK(J - I)
         ENDDO
      ENDDO
C
C Finally normalise all the probabilities
C
      WRK(K0) = WRK(K0)/BINOM
      DO J = K1, NUPPER
         WRK(J) = WRK(J - K1) + WRK(J)/BINOM
      ENDDO
C
C Choose the appropriate P value depending on C1 = TAIL(1:1)
C
      J = NINT(U)
      IF (C1.EQ.'L') THEN
         P = WRK(J)
      ELSEIF (C1.EQ.'U') THEN
         IF (U.GE.ONE) THEN
            J = NINT(U - ONE)
            P = ONE - WRK(J)
         ELSE
            P = ONE
         ENDIF
      ELSE
         P = WRK(J)
         IF (P.LE.HALF) THEN
            P = TWO*P
         ELSE
            IF (U.GE.ONE) THEN
               J = NINT(U - ONE)
               P = WRK(J)
               P = TWO*(ONE - P)
            ELSE
               P = ONE
            ENDIF
         ENDIF
      ENDIF
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C
