C
C
      SUBROUTINE G08AKF$(N1, N2, TAIL, RANKS, U, P, WRK, LWRK, IWRK,
     +                   IFAIL)
C
C ACTION : Exact MWU p by Neumanns method
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/5/97
C          20/04/2004 revised
C          See Neumann N Stat Soft Newsletter 14, 3, 120-126 (1988)
C
C          The arrays are used in a complicated way as follows:-
C          m1 = min(n1,n2), m2=max(n1,n2)
C          IWRK(1:m1+m2) = RANK(1:m1+m2)
C          IWRK(m1+m2+1:2m1+m2+1) = LIMIT(0:m1)
C          IWRK(2m1+m2+2:2(m1+m2+1)) = UPPER(0:m1)
C          WRK(0:?) = WORK(0:?)
C          WRK(?+1:?+1+U) = PROB(0:U)
C
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER    IFAIL, LWRK, N1, N2, IWRK(2*(N1 + N2 + 1))
      DOUBLE PRECISION P, RANKS(N1 + N2), U, WRK(0:LWRK - 1)
      CHARACTER  TAIL*(*)
C
C Local variables
C
      INTEGER    K0, K1, K2, K3, K4
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4)
      INTEGER    I, IU, J, K, M, M1, M2, N
      INTEGER    NDUMMY, NHIGH, NLOW, NRANK, NSHIFT, NSUM, NSPACE
      INTEGER    NSTART_LIMIT, NSTART_PROB, NSTART_UPPER
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION DLAMDA
      CHARACTER  C1*1
      LOGICAL    CHANGE, SWAP
      INTRINSIC  MAX, MIN, NINT, DBLE
C
C Is it safe ?
C
      IFAIL = K0
C
C Check N1, N2 and U
C
      IF (N1.LT.K1 .OR. N2.LT.K1) THEN
         IFAIL = K1
         RETURN
      ENDIF
      IF (U.LT.ZERO) THEN
         IFAIL = K3
         RETURN
      ENDIF
C
C Multiply U by 2 to remove halves then check for extreme values
C
      IU = NINT(TWO*U)
      C1 = TAIL(K1:K1)
      IF (C1.EQ.'T' .OR. C1.EQ.'t') THEN
         IF (IU.LE.N1*N2) THEN
            SWAP = .FALSE.
         ELSE
            IU = IU - K1
            SWAP = .TRUE.
         ENDIF
         C1 = 'T'
      ELSEIF (C1.EQ.'U' .OR. C1.EQ.'u') THEN
         IF (IU.EQ.K0) THEN
            P = ONE
            RETURN
         ELSE
            IU = IU - K1
         ENDIF
         SWAP = .TRUE.
         C1 = 'U'
      ELSEIF (C1.EQ.'L' .OR. C1.EQ.'l') THEN
         IF (IU.EQ.K2*N1*N2) THEN
            P = ONE
            RETURN
         ENDIF
         SWAP = .FALSE.
         C1 = 'L'
      ELSE
         IFAIL = K2
         RETURN
      ENDIF
      N = MIN(N1, N2)
      M = MAX(N1, N2)
      I = N + N*(N + K1)*(N + M) - (N*(N + K1)*(K2*N + K1))/K3 + K1
      IF (LWRK.LT.I) THEN
         IFAIL = K4
         RETURN
      ENDIF
C
C Copy N1 and N2 then work out all of the possible probabilities
C
      M1 = N1
      M2 = N2
      IF (M1.LT.M2) THEN
         CHANGE = .FALSE.
      ELSE
         CHANGE = .TRUE.
         NDUMMY = M1
         M1 = M2
         M2 = NDUMMY
      ENDIF
C
C Initialise then copy RANKS into IWRK(1:N1 + N2)
C
      NSUM = M1 + M2
      NSTART_LIMIT = NSUM + K1
      NSTART_UPPER = NSTART_LIMIT + M1 + K1
      DO I = K1, NSUM
         IWRK(I) = NINT(TWO*RANKS(I))
      ENDDO
C
C Bubble sort IWRK(1:N1 + N2)
C
      DO I = K1, NSUM - K1
         DO J = I + K1, NSUM
            IF (IWRK(I).GT.IWRK(J)) THEN
               NDUMMY = IWRK(I)
               IWRK(I) = IWRK(J)
               IWRK(J) = NDUMMY
            ENDIF
         ENDDO
      ENDDO
C
C Starting values
C
      NLOW = K0
      NHIGH = K0
      NSPACE = K0
      IWRK(NSTART_UPPER) = K0
      IWRK(NSTART_LIMIT) = K0
      DO M = K1, M1
         IWRK(NSTART_UPPER + M) = K0
         IWRK(NSTART_LIMIT + M) = NSPACE + K1
         NLOW = NLOW + IWRK(M)
         NHIGH = NHIGH + IWRK(NSUM + K1 - M)
         NDUMMY = NHIGH - NLOW + K1
         NSPACE = NSPACE + NDUMMY
      ENDDO
C
C Calculate rank sum
C
      NRANK = NLOW
      DO M = M1 + K1, NSUM
         NRANK = NRANK + IWRK(M)
      ENDDO
      DO I = K0, NSPACE
         WRK(I) = ONE
      ENDDO
C
C Recurrence
C
      NSTART_PROB = K0
      DO N = K1, NSUM
         IF (N.GT.M1) THEN
            NDUMMY = M1
         ELSE
            NDUMMY = N
         ENDIF
         DO M = NDUMMY, K1, - K1
            NSHIFT = IWRK(N) - IWRK(M)
            IWRK(NSTART_UPPER + M) =
     +      IWRK(NSTART_UPPER + M  - K1) + NSHIFT
            DLAMDA = DBLE(M)/DBLE(N)
            DO J = K0, IWRK(NSTART_UPPER + M)
               K = IWRK(NSTART_LIMIT + M) + J
               WRK(K) = (ONE - DLAMDA)*WRK(K)
               IF (NSHIFT.LE.J) THEN
                  WRK(K) = WRK(K) +
     +                     DLAMDA*WRK(IWRK(NSTART_LIMIT  + M - K1) +
     +                     J - NSHIFT)
               ENDIF
               IF (K.GT.NSTART_PROB) NSTART_PROB = K
            ENDDO
         ENDDO
      ENDDO
C
C Choose the appropriate P value depending on C1 = TAIL(1:1)
C
      J = NLOW - M1*(M1 + K1)
      IF (CHANGE) THEN
         P = ONE - WRK(IWRK(NSTART_LIMIT + M1) +
     +                 IWRK(NSTART_UPPER + M1) - IU + J - K1)
      ELSE
         P = WRK(IWRK(NSTART_LIMIT + M1) + IU - J)
      ENDIF
      IF (SWAP) P = ONE - P
      IF (C1.EQ.'T') P = TWO*P
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C
