C     
C
      SUBROUTINE G08BAF$(X, N, N1, R, ITEST, W, V, PW, PV, IFAIL)
C
C ACTION: Simfit replacement for G08BAF
C AUTHOR: w.g.bardsley, university of manchester, u.k., 19/09/2012
C
C
C Note that V can be calculated from W and vice versa using
C      
C W = DBLE(N1 - 1)*V + DBLE(N1)*(RBAR - DBLE(N + 1)/TWO)**2
C V = W/DBLE(N1 - 1) - DBLE(N1)*(RBAR - FACTOR)**2/DBLE(N1 - 1)
C
C Arguments
C  
      IMPLICIT NONE
      INTEGER  N, N1, ITEST, IFAIL
      DOUBLE PRECISION X(N), R(N), W, V, PW, PV
C
C Locals
C
      INTEGER    I, N2      
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      DOUBLE PRECISION BOT, FACTOR, RBAR, TOP, Z
      DOUBLE PRECISION DN, DNP1, DN1, DN1M1, DN1P1, DN2, DNSQD
      DOUBLE PRECISION G01EAF$
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FOUR, F12, F180
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FOUR = 4.0D+00, F12 = 12.0D+00, 
     +           F180 = 180.0D+00)
      LOGICAL    DAVID, MOOD
      EXTERNAL   RANKIT, G01EAF$
      INTRINSIC  DBLE, SQRT
C
C Initialise
C      
      PV = ZERO
      PW = ZERO
      W = ZERO
      V = ZERO
C
C Check
C
      IFAIL = 1
      IF (N.LE.2) RETURN
      IFAIL = 2
      IF (N1.LE.1 .OR. N1.GE.N) RETURN
      IFAIL = 3
      IF (ITEST.EQ.0) THEN
         DAVID = .TRUE.
         MOOD = .TRUE.
      ELSEIF (ITEST.EQ.1) THEN
         DAVID = .TRUE.
         MOOD = .FALSE.
      ELSEIF (ITEST.EQ.2) THEN
         DAVID = .FALSE.
         MOOD = .TRUE.
      ELSE
         RETURN
      ENDIF      
      IFAIL = 0       
      CALL RANKIT (ISEND, N,
     +             X, FACTOR, R)
      N2 = N - N1
      DN = DBLE(N)
      DNSQD = DN**2
      DNP1 = DBLE(N + 1)
      DN1 = DBLE(N1)
      DN1M1 = DBLE(N1 - 1)
      DN1P1 = DBLE(N1 + 1)
      DN2 = DBLE(N2)
C
C The David test
C     
      IF (DAVID) THEN
         RBAR = ZERO
         DO I = 1, N1
            RBAR = RBAR + R(I)
         ENDDO
         RBAR = RBAR/DN1   
         DO I = 1, N1
            V = V + (R(I) - RBAR)**2
         ENDDO
         V = V/DN1M1  
         TOP = V - DN*DNP1/F12
         BOT = SQRT(DN*DN2*DNP1*(THREE*DNP1*DN1P1 - DN*DN1)/
     +        (TWO*F180*DN1*DN1M1))
         Z = TOP/BOT
         PV = G01EAF$('L', Z, IFAIL)
      ENDIF
C
C The Mood test
C       
      IF (MOOD) THEN
         FACTOR = DNP1/TWO
         DO I = 1, N1
            W = W + (R(I) - FACTOR)**2
         ENDDO
         TOP = W - DN1*(DNSQD - ONE)/F12
         BOT = SQRT(DN1*DN2*DNP1*(DNSQD - FOUR)/F180)
         Z = TOP/BOT
         PW = G01EAF$('L', Z, IFAIL)
      ENDIF
      END
C
C          
               