C
C G08CBF$
C CDFVAL$
C
C This version requires CDFVAL$
C =============================
C
C
       SUBROUTINE G08CBF$(N, X, DIST, PAR, ESTIMA, NTYPE, D, Z, P, SX,
     +                    IFAIL)
C
C ACTION : 1 sample Kolmogorov-Smirnov test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 2/5/97
C          IFAIL is not tested on entry so it is like IFAIL = 1
C          Note that the NAG routine mistakenly reverses alpha and
C          beta when they are estimated from the sample moments for
C          the gamma distribution. (This was corrected at Mark 18)
C          28/08/1998 added lognormal
C          02/04/2000 corrected integers and D- for binomial and Poisson and
C                     added t, chi-square and F distributions
C          20/08/2001 added test for data < rtol for lognormal
C          22/12/2003 changed NXXBAR$, NXSORT$ to NXXBAR, NXSORT
C          27/04/2004 changed PROBKS$ to PROBKS
C                     Note: the p-values do not agree very closely with NAG for
C                     very small samples but I have checked that my routine PROBKS
C                     seems to be working well with ACM 487. Note the factor of 2 in
C                     the Kolmogorov series exponential argument which seems OK but
C                     is missing in Kolmogorov (1948) and Fellar (1948)
C          15/07/2022 changed exponential so mean = xbar not 1/xbar
C
      IMPLICIT   NONE
C
C Subroutine arguments
C
      INTEGER    IFAIL, NTYPE, N
      DOUBLE PRECISION D, P, PAR(*), SX(N), X(N), Z
      CHARACTER  DIST*(*), ESTIMA*(*)
C
C Local arguments
C
      INTEGER    K0, K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K11, K12
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K11 = 11, K12 = 12)
      INTEGER    I, ISEND, ITEMP
      DOUBLE PRECISION RTOL, X02AMF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION CDF, CDFVAL$, CDF0, CDF1, DELTA, DN, DMINUS,
     +                 DPLUS, D1, D5, XBAR, XVAR, Y1, Y2
      CHARACTER  C1*1, C2*2
      LOGICAL    OK
      EXTERNAL   X02AMF$
      EXTERNAL   CDFVAL$, PROBKS
      EXTERNAL   NXSORT, NXXBAR
      INTRINSIC  ABS, DBLE, NINT, SQRT, MAX, LOG, EXP
C
C ======================================================================
C Part 1: Check the data supplied
C ======================================================================
C
C
C Is it safe ?
C
      IFAIL = K0
      D = ZERO
      P = ZERO
      Z = ZERO
C
C Check the sample size
C
      IF (N.LT.K3) THEN
         IFAIL = K1
         RETURN
      ENDIF
C
C Check that a valid distribution has been chosen
C
      C1 = DIST(K1:K1)
      C2 = DIST(K1:K2)
      IF (C1.EQ.'U' .OR. C1.EQ.'u') THEN
C
C Uniform distribution
C
         ISEND = K1
      ELSEIF (C1.EQ.'N' .OR. C1.EQ.'n') THEN
C
C Normal distribution
C
         ISEND = K2
      ELSEIF (C1.EQ.'G' .OR. C1.EQ.'g') THEN
C
C Gamma distribution
C
         ISEND = K3
      ELSEIF (C2.EQ.'BE' .OR. C2.EQ.'Be' .OR. C2 .EQ.'bE' .OR.
     +        C2.EQ.'be') THEN
C
C Beta distribution
C
         ISEND = K4
      ELSEIF (C2.EQ.'BI' .OR. C2.EQ.'Bi' .OR. C2.EQ.'bI' .OR.
     +        C2.EQ.'bi') THEN
         ISEND = K5
      ELSEIF (C1.EQ.'E' .OR. C1.EQ.'e') THEN
C
C Exponential distribution
C
         ISEND = K6
      ELSEIF (C1.EQ.'P' .OR. C1.EQ.'p') THEN
C
C Poisson distribution
C
         ISEND = K7
      ELSEIF (C1.EQ.'L' .OR. C1.EQ.'l') THEN
C
C lognormal  distribution
C
         ISEND = K8
      ELSEIF (C1.EQ.'W' .OR. C1.EQ.'w') THEN
C
C Weibull distribution
C
         ISEND = K9
      ELSEIF (C1.EQ.'T' .OR. C1.EQ.'t') THEN
C
C t distribution
C
         ISEND = K10
      ELSEIF (C1.EQ.'C' .OR. C1.EQ.'c') THEN
C
C chi-square distribution
C
         ISEND = K11
      ELSEIF (C1.EQ.'F' .OR. C1.EQ.'f') THEN
C
C F distribution
C
         ISEND  = K12
      ELSE
         IFAIL = K2
         RETURN
      ENDIF
C
C Check that a consistent test has been selected
C
      IF (NTYPE.LT.K1 .OR. NTYPE.GT.K3) THEN
         IFAIL = K3
         RETURN
      ENDIF
C
C Check ESTIMA
C
      IF (ISEND.LE.K9) THEN
         C1 = ESTIMA(K1:K1)
         IF (C1.EQ.'S' .OR. C1.EQ.'s') then
            C1 = 'S'
         ELSEIF (C1.EQ.'E' .OR. C1.EQ.'e') THEN
            C1 = 'E'
         ELSE
            IFAIL = K4
            RETURN
         ENDIF
      ELSE
         C1 = 'S'
      ENDIF
C
C Sort then check that valid parameters have been supplied
C
      DO I = K1, N
         SX(I) = X(I)
      ENDDO
      CALL NXSORT (N, SX)
C
C Truncate to integers if binomial or Poisson
C
      IF (ISEND.EQ.K5 .OR. ISEND.EQ.K7) THEN
         DO I = K1, N
            ITEMP = NINT(SX(I))
            SX(I) = DBLE(ITEMP)
         ENDDO
      ENDIF
      RTOL = 1.0D+09*X02AMF$()
      IF ((SX(N) - SX(1)).LE.RTOL) THEN
         IF (ISEND.EQ.K1 .OR.
     +       ISEND.EQ.K2 .OR.
     +       ISEND.EQ.K3 .OR.
     +       ISEND.EQ.K4 .OR.
     +       ISEND.EQ.K8 .OR.
     +       ISEND.EQ.K9 .OR.
     +       ISEND.EQ.K10 .OR.
     +       ISEND.EQ.K11 .OR.
     +       ISEND.EQ.K12) THEN
             IFAIL = K6
             RETURN
         ENDIF
      ENDIF
      OK = .TRUE.
      IF (C1.EQ.'S') THEN
         IF (ISEND.EQ.K1) THEN
            IF (PAR(1).GE.PAR(2)) OK = .FALSE.
         ELSEIF (ISEND.EQ.K2) THEN
            IF (PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K3) THEN
            IF (PAR(1).LT.ZERO .OR. PAR(2).LT.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K4) THEN
            IF (PAR(1).LE.ZERO .OR. PAR(2).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K5) THEN
            IF (PAR(1).LT.ONE .OR. PAR(2).LT.ZERO .OR.
     +          PAR(2).GT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K6) THEN
            IF (PAR(1).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K7) THEN
            IF (PAR(1).LE.ZERO) OK = .FALSE.
         ELSEIF (ISEND.EQ.K8) THEN
            IF (PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K9) THEN
            IF (PAR(1).LE.RTOL .OR.
     +          PAR(2).LE.RTOL) OK = .FALSE.
         ELSEIF (ISEND.EQ.K10) THEN
            IF (PAR(1).LT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K11) THEN
            IF (PAR(1).LT.ONE) OK = .FALSE.
         ELSEIF (ISEND.EQ.K12) THEN
            IF (PAR(1).LT.ONE .OR.
     +          PAR(2).LT.ONE) OK = .FALSE.
         ENDIF
      ELSE
         IF (ISEND.EQ.K5 .AND. PAR(1).LT.ONE) OK = .FALSE.
      ENDIF
      IF (.NOT.OK) THEN
         IFAIL = K5
         RETURN
      ENDIF
C
C ======================================================================
C Part 2 : Check the data values
C ======================================================================
C
C Check that the data are consistent with the chosen distribution
C
      OK = .TRUE.
      IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
         IF (C1.EQ.'S') THEN
            IF (SX(1).LT.PAR(1) .OR. SX(N).GT.PAR(2)) OK = .FALSE.
         ENDIF
      ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
         IF (SX(1).LT.ZERO .OR. SX(N).GT.ONE) OK = .FALSE.
      ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
         IF (SX(1).LT.ZERO .OR. SX(N).GT.PAR(1)) OK = .FALSE.
      ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K8) THEN
C
C Lognormal
C
         IF (SX(1).LE.RTOL) OK = .FALSE.
      ELSEIF (ISEND.EQ.K9) THEN
C
C Weibull
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K11) THEN
C
C chi-square
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ELSEIF (ISEND.EQ.K12) THEN
C
C F
C
         IF (SX(1).LT.ZERO) OK = .FALSE.
      ENDIF
      IF (.NOT.OK) THEN
         IFAIL = K6
         RETURN
      ENDIF
C
C ======================================================================
C Part 3: Estimate parameters from the sample
C ======================================================================
C
C Estimate parameters from the sample
C
      DN = DBLE(N)
      IF (C1.EQ.'E') THEN
         IF (ABS(SX(K1) - SX(N)).LE.RTOL .AND. ISEND.LE.K4) THEN
            IFAIL = K7
            RETURN
         ENDIF
         IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
            PAR(1) = SX(1)
            PAR(2) = SX(N)
         ELSEIF (ISEND.EQ.K2) THEN
C
C Normal distribution
C
            CALL NXXBAR (N, SX, XBAR, XVAR)
            PAR(1) = XBAR
            PAR(2) = XVAR
         ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
            CALL NXXBAR (N, SX, XBAR, XVAR)
            PAR(2) = XVAR/XBAR
            PAR(1) = XBAR/PAR(2)
         ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
            CALL NXXBAR (N, SX, XBAR, XVAR)
            Y1 = XBAR**2/XVAR
            Y2 = ONE/XBAR - ONE
            PAR(1) = XBAR*(Y1*Y2 - ONE)
            PAR(2) = PAR(1)*Y2
            IF (PAR(1).LT.RTOL) PAR(1) = RTOL
            IF (PAR(2).LT.RTOL) PAR(2) = RTOL
         ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
            CALL NXXBAR (N, SX, XBAR, XVAR)
            PAR(2) = XBAR/PAR(1)
         ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
             CALL NXXBAR (N, SX, XBAR, XVAR)
             PAR(1) = XBAR! 15/07/2022 changed from ONE/XBAR
         ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
            CALL NXXBAR (N, SX, XBAR, XVAR)
            PAR(1) = XBAR
         ELSEIF (ISEND.EQ.K8) THEN
C
C lognormal
C
            DO I = 1, N
               SX(I) = LOG(SX(I))
            ENDDO
            CALL NXXBAR (N, SX, XBAR, XVAR)
            PAR(1) = XBAR
            PAR(2) = XVAR
            DO I = 1, N
               SX(I) = EXP(SX(I))
            ENDDO
         ENDIF
      ENDIF
C
C Check np(1 - p) if Binomial distribution
C
      IF (ISEND.EQ.K5) THEN
         XVAR = PAR(1)*PAR(2)*(ONE - PAR(2))
         IF (XVAR.GT.1000000.0D+00) THEN
            IFAIL = K8
            RETURN
         ENDIF
      ENDIF
C
C ======================================================================
C Part 4: Calculate the D values
C ======================================================================
C
C
C Initialise all the counters
C
      CDF0 = ZERO
      CDF1 = ZERO
      DELTA = ZERO
      DPLUS = ZERO
      DMINUS = ZERO
      IF (ISEND.EQ.K5 .OR. ISEND.EQ.K7) THEN
C
C Special action for discrete distributions since CDF0 not tested
C
         DO I = K1, N
            IF (I.LT.N) THEN
               IF (SX(I + K1).GT.SX(I)) THEN
C
C The next X increases
C
                  OK = .TRUE.
              ELSE
C
C The next X is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next X is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = CDFVAL$(ISEND, PAR, SX(I))
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPLUS) DPLUS = DELTA
               IF (DELTA.LT.DMINUS) DMINUS = DELTA
            ENDIF
         ENDDO
      ELSE
         DO I = K1, N
            IF (I.LT.N) THEN
               IF (SX(I + K1).GT.SX(I)) THEN
C
C The next X increases
C
                  OK = .TRUE.
              ELSE
C
C The next X is a replicate
C
                  OK = .FALSE.
               ENDIF
            ELSE
C
C The next X is the last
C
               OK = .TRUE.
            ENDIF
            IF (OK) THEN
C
C The end of one or a group of replicates so do the sums
C
               CDF = CDFVAL$(ISEND, PAR, SX(I))
               CDF1 = DBLE(I)/DN
               DELTA = CDF1 - CDF
               IF (DELTA.GT.DPLUS) DPLUS = DELTA
               DELTA = CDF0 - CDF
               IF (DELTA.LT.DMINUS) DMINUS = DELTA
               CDF0 = CDF1
            ENDIF
         ENDDO
      ENDIF
C
C ======================================================================
C Part 5: Adjust the D and P values
C ======================================================================
C
      IF (NTYPE.EQ.K1) THEN
         D = MAX (- DMINUS, DPLUS)
      ELSEIF (NTYPE.EQ.K2) THEN
         D = DPLUS
      ELSE
         D = - DMINUS
      ENDIF
      CALL PROBKS (N, D, D1, D5, P)
      IF (NTYPE.GT.K1) P = P/TWO
      Z = D*SQRT(DN)
      END
C
C
      DOUBLE PRECISION FUNCTION CDFVAL$(ISEND, PAR, X)
C
C ACTION : CDF for probability distributions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 2/5/97
C          28/8/98 Added lognormal and Weibull
C          04/04/2000 Added t, chi-square and F
C
      IMPLICIT   NONE
      INTEGER    ISEND
      INTEGER    K1, K2, K3, K4, K5, K6, K7, K8, K9, K10, K11, K12
      PARAMETER (K1 = 1, K2 = 2, K3 = 3, K4 = 4, K5 = 5, K6 = 6,
     +           K7 = 7, K8 = 8, K9 = 9, K10 = 10, K11 = 11, K12 = 12)
      INTEGER    IFAIL, N, K
      DOUBLE PRECISION PAR(*), X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION A, B, G, P, PDF, PEQK, PGTK, PLEK, Q, RTOL,
     +                 TOL, XNEW, Z
      DOUBLE PRECISION S15ABF$, X02AJF$, X02AMF$, G01EBF$, G01ECF$,
     +                 G01EDF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   S14BAF$, S15ABF$, X02AJF$, X02AMF$, G01EBF$, G01ECF$,
     +           G01EDF$
      EXTERNAL   G01EEF$, G01BJF$
      INTRINSIC  NINT, EXP, SQRT, LOG
      IF (ISEND.EQ.K1) THEN
C
C Uniform distribution
C
         A = X - PAR(K1)
         B = PAR(K2) - PAR(K1)
         CDFVAL$ = A/B
      ELSEIF (ISEND.EQ.K2) THEN
C
C Normal distribution
C
         RTOL = 1.0D+09*X02AMF$()
         IF (PAR(2).GT.RTOL) THEN
            XNEW = (X - PAR(K1))/SQRT(PAR(K2))
            IFAIL = K1
            CDFVAL$ = S15ABF$(XNEW, IFAIL)
         ELSE
            CDFVAL$ = ZERO
         ENDIF
      ELSEIF (ISEND.EQ.K3) THEN
C
C Gamma distribution
C
         G = X
         Z = G/PAR(K2)
         A = PAR(K1)
         TOL = 1.0D+02*X02AJF$()
         IFAIL = K1
         CALL S14BAF$(A, Z, TOL, P, Q, IFAIL)
         CDFVAL$ = P
      ELSEIF (ISEND.EQ.K4) THEN
C
C Beta distribution
C
         A = PAR(K1)
         B = PAR(K2)
         TOL = 1.0D+02*X02AJF$()
         IFAIL = K1
         CALL G01EEF$(X, A, B, TOL, P, Q, PDF, IFAIL)
         CDFVAL$ = P
      ELSEIF (ISEND.EQ.K5) THEN
C
C Binomial distribution
C
         N = NINT(PAR(K1))
         K = NINT(X)
         P = PAR(K2)
         IFAIL = K1
         CALL G01BJF$(N, P, K, PLEK, PGTK, PEQK, IFAIL)
         CDFVAL$ = PLEK
      ELSEIF (ISEND.EQ.K6) THEN
C
C Exponential distribution
C
         XNEW = - PAR(1)*X
         IF (XNEW.LT.-100.0D+00) THEN
            CDFVAL$ = ZERO
         ELSEIF (XNEW.GT.100.0D+00) THEN
            CDFVAL$ = ONE
         ELSE
            CDFVAL$ = ONE - EXP(XNEW)
         ENDIF
      ELSEIF (ISEND.EQ.K7) THEN
C
C Poisson distribution
C
         IFAIL = K1
         TOL = 1.0D+02*X02AJF$()
         A = PAR(K1)
         XNEW = X + ONE
         CALL S14BAF$(XNEW, A, TOL, P, Q, IFAIL)
         CDFVAL$ = Q
      ELSEIF (ISEND.EQ.K8) THEN
C
C lognormal distribution
C
         RTOL = 1.0D+09*X02AMF$()
         IF (PAR(2).GT.RTOL) THEN
            XNEW = (LOG(X) - PAR(K1))/SQRT(PAR(K2))
            IFAIL = K1
            CDFVAL$ = S15ABF$(XNEW, IFAIL)
         ELSE
            CDFVAL$ = ZERO
         ENDIF
      ELSEIF (ISEND.EQ.K9) THEN
C
C Weibull distribution
C
         XNEW = - (PAR(1)*X)**PAR(2)
         IF (XNEW.LT.-100.0D+00) THEN
            CDFVAL$ = ZERO
         ELSEIF (XNEW.GT.100.0D+00) THEN
            CDFVAL$ = ONE
         ELSE
            CDFVAL$ = ONE - EXP(XNEW)
         ENDIF
      ELSEIF (ISEND.EQ.K10) THEN
C
C t distribution
C
         IFAIL = K1
         CDFVAL$ = G01EBF$(TAIL, X, PAR(K1), IFAIL)
      ELSEIF (ISEND.EQ.K11) THEN
C
C Chi-square distribution
C
         IFAIL = K1
         CDFVAL$ = G01ECF$(TAIL, X, PAR(K1), IFAIL)
      ELSEIF (ISEND.EQ.K12) THEN
C
C F distribution
C
         IFAIL = K1
         CDFVAL$ =  G01EDF$(TAIL, X, PAR(K1), PAR(K2), IFAIL)
      ENDIF
      END
C
C
