
C
C This version calls ksprob and nxsort
C ====================================
C Note: This version does not agree exactly with the NAG routine when
C       counting ties and the P values are not calculated by the same
C       method. It does agree very closely with the NAG routine with
C       large samples and continuous data.
C
C       22/12/2003 changed NXSORT$ to NXSORT
C       27/04/2004 changed PROBKS$ to KSPROB
C
       SUBROUTINE G08CDF$(N1, X, N2, Y, NTYPE, D, Z, P, SX, SY, IFAIL)
C
C ACTION : 2 sample Kolmogorov Smirnov test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 2/5/97
C          IFAIL is not tested on entry so it is like IFAIL = 1
C
      IMPLICIT   NONE
C
C Subroutine arguments
C
      INTEGER    IFAIL, NTYPE, N1, N2
      DOUBLE PRECISION D, P, SX(N1), SY(N2), X(N1), Y(N2), Z
C
C Local arguments
C
      INTEGER    K0, K1, K2, K3
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3)
      INTEGER    I, IX, IY
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION CDFX0, CDFX1, CDFY0, CDFY1, DELTA, DN1, DN2,
     +                 DMINUS, DPLUS, RATIO, XTEMP, YTEMP
      EXTERNAL   KSPROB, NXSORT
      INTRINSIC  DBLE, SQRT, MAX
C
C Is it safe ?
C
      IFAIL = K0
      IF (N1.LT.K1 .OR. N2.LT.K1) THEN
         IFAIL = K1
         RETURN
      ELSEIF (NTYPE.LT.K1 .OR. NTYPE.GT.K3) THEN
         IFAIL = K2
         RETURN
      ENDIF
C
C Sort the values into increasing order
C
      DO I = K1, N1
         SX(I) = X(I)
      ENDDO
      CALL NXSORT (N1, SX)
      DO I = K1, N2
         SY(I) = Y(I)
      ENDDO
      CALL NXSORT (N2, SY)
C
C Initialise all the counters
C
      CDFX0 = ZERO
      CDFX1 = ZERO
      CDFY0 = ZERO
      CDFY1 = ZERO
      DELTA = ZERO
      DMINUS = ZERO
      DPLUS = ZERO
      DN1 = DBLE(N1)
      DN2 = DBLE(N2)
      IX = K1
      IY = K1
C
C Return to label 20 until all values have been analysed
C
   20 CONTINUE
      IF (IX.LE.N1 .AND. IY.LE.N2) THEN
C
C Define the next pair for comparison
C
         XTEMP = SX(IX)
         YTEMP = SY(IY)
         IF (XTEMP.LT.YTEMP) THEN
C
C X precedes next Y so find the distances before/after the step in the cdf
C
            DELTA = CDFX0 - CDFY0
            IF (DELTA.GT.DPLUS) DPLUS = DELTA
            IF (DELTA.LT.DMINUS) DMINUS = DELTA
            CDFX1 = DBLE(IX)/DN1
            DELTA = CDFX1 - CDFY0
            IF (DELTA.GT.DPLUS) DPLUS = DELTA
            IF (DELTA.LT.DMINUS) DMINUS = DELTA
            CDFX0 = CDFX1
            IX = IX + K1
         ELSEIF (XTEMP.GT.YTEMP) THEN
C
C X follows Y
C
            DELTA = CDFX0 - CDFY0
            IF (DELTA.GT.DPLUS) DPLUS = DELTA
            IF (DELTA.LT.DMINUS) DMINUS = DELTA
            CDFY1 = DBLE(IY)/DN2
            DELTA = CDFX0 - CDFY1
            IF (DELTA.GT.DPLUS) DPLUS = DELTA
            IF (DELTA.LT.DMINUS) DMINUS = DELTA
            CDFY0 = CDFY1
            IY = IY + K1
         ELSE
C
C A tie has occurred
C
            CDFX1 = DBLE(IX)/DN1
            CDFY1 = DBLE(IY)/DN2
            DELTA = CDFX1 - CDFY1
            IF (DELTA.GT.DPLUS) DPLUS = DELTA
            IF (DELTA.LT.DMINUS) DMINUS = DELTA
            CDFX0 = CDFX1
            CDFY0 = CDFY1
            IX = IX + K1
            IY = IY + K1
         ENDIF
         GOTO 20
      ENDIF
      IF (NTYPE.EQ.K1) THEN
         D = MAX (- DMINUS, DPLUS)
      ELSEIF (NTYPE.EQ.K2) THEN
         D = DPLUS
      ELSE
         D = - DMINUS
      ENDIF
      RATIO = DN1*DN2/(DN1 + DN2)
      Z = D/SQRT(RATIO)
      CALL KSPROB (N1, N2, D, DMINUS, DPLUS, P)
      IF (NTYPE.GT.K1) P = P/TWO
      IF (P.LT.ZERO) THEN
         P = ZERO
      ELSEIF (P.GT.ONE) THEN
         P = ONE
      ENDIF
      END
C
C


