C
C
      SUBROUTINE G08DAF$(X, IX, K, N, RNK, W, P, IFAIL)
C
C ACTION: substitute for G08DAF
C AUTHOR: w.g.bardsley, university of manchester, u.k., 20/09/2012 
C      
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER IX, K, N, IFAIL
      DOUBLE PRECISION X(IX,N), RNK(IX,N), W, P
C
C Locals
C       
      DOUBLE PRECISION, ALLOCATABLE :: RANK(:), Y(:)
      INTEGER    I, IERR, J
      INTEGER    ISEND
      PARAMETER (ISEND = 1)
      DOUBLE PRECISION G01ECF$
      DOUBLE PRECISION CHISQD, DK, DN, DOF, FACTOR, T
      DOUBLE PRECISION ZERO, ONE, TWO, F12
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           F12 = 12.0D+00)
      INTRINSIC  DBLE
      EXTERNAL   RANKIT, G01ECF$
C
C Initialise and check arguments
C      
      W = ZERO
      P = ZERO
      IFAIL = 1
      IF (N.LT.2) RETURN
      IFAIL = 2
      IF (IX.LT.K) RETURN
      IFAIL = 3
      IF (K.LE.1) RETURN
C
C Allocate
C        
      IFAIL = -100
      IERR = 0  
      IF (ALLOCATED(RANK)) DEALLOCATE(RANK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      J = N  
      ALLOCATE(RANK(J), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      J = N  
      ALLOCATE(Y(J), STAT = IERR)
      IF (IERR.NE.0) RETURN  
C
C Calculate W
C        
      IFAIL = 0 
      T = ZERO
      DO I = 1, K
         DO J = 1, N
            Y(J) = X(I,J)
         ENDDO  
         FACTOR = ZERO 
         CALL RANKIT (ISEND, N, 
     +                Y, FACTOR, RANK)
         IF (FACTOR.GT.ZERO) T = T + FACTOR
         DO J = 1, N
            RNK(I,J) = RANK(J)
         ENDDO   
      ENDDO  
      DO I = 1, N
         RANK(I) = ZERO
      ENDDO     
      DO J = 1, N
         DO I = 1, K
            RANK(J) = RANK(J) + RNK(I,J)
         ENDDO   
      ENDDO 
      DN = DBLE(N)
      DK = DBLE(K)
      FACTOR = DK*(DN + ONE)/TWO  
      DO I = 1, N
         W = W + (RANK(I) - FACTOR)**2
      ENDDO
      FACTOR = DK**2*DN*(DN**2 - ONE)/F12 - DK*T
      W = W/FACTOR 
C
C Calculate P
C       
      CHISQD = DK*(DN - ONE)*W 
      DOF = DN - ONE
      P = G01ECF$('U', CHISQD, DOF, IFAIL)
C
C Deallocate
C      
      DEALLOCATE(RANK, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      END
C
C        