
C 
C Action: SIMFIT version of G10ABF 
C Author: w.g.bardsley, university of manchester, u.k., 30/10/2012
C
C This substitute for G10ABF has two limitations as follows:
C 1) It behaves like MODE = 'F' for all values of MODE
C 2) It requires that ACM642 = CUBGCV be edited at several places 
C 3) It requires IER to be set on entry to CUBGCV to allow for future
C    developments with MODE = 'P' and 'Q' 
C I intend to eventually allow other values of MODE   
C
      SUBROUTINE G10ABF$(MODE, WEIGHT, N, X, Y, WT, RHO, YHAT, C, LDC,
     +                   RSS, DF, RES, H, WK, IFAIL)
      IMPLICIT NONE
C
C Arguments
C  
      INTEGER N, LDC, IFAIL
      DOUBLE PRECISION X(N), Y(N), WT(*), RHO, YHAT(N), C(LDC,3), RSS,
     +                 DF, RES(N), H(N), WK(9*N + 14)
      CHARACTER (LEN = 1) MODE, WEIGHT
C
C Allocatable
C 
      DOUBLE PRECISION, ALLOCATABLE :: W(:)     
C
C Locals
C
      INTEGER I, IER, JOB
      DOUBLE PRECISION VAR
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00) 
      CHARACTER (LEN = 1) MODE_SAV, WEIGHT_SAV   
      
      EXTERNAL CUBGCV
      INTRINSIC SQRT

      IFAIL = 1
      IF (N.LT.3 .OR. LDC.LT.N - 1 .OR. RHO.LT.ZERO) RETURN  
      IF (MODE.EQ.'Q' .OR. MODE.EQ.'q') THEN
         MODE_SAV = 'Q'
      ELSEIF (MODE.EQ.'P' .OR. MODE.EQ.'p') THEN
         MODE_SAV = 'P'
      ELSEIF (MODE.EQ.'F' .OR. MODE.EQ.'f') THEN
         MODE_SAV = 'F'
      ELSE
         MODE_SAV = 'X'   
      ENDIF
      IF (MODE_SAV.NE.'Q' .AND.
     +    MODE_SAV.NE.'P' .AND.
     +    MODE_SAV.NE.'F') RETURN
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         WEIGHT_SAV = 'W'
      ELSEIF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         WEIGHT_SAV = 'U'
      ELSE
         RETURN
      ENDIF 
      IFAIL = 2 
      IF (WEIGHT_SAV.EQ.'W') THEN 
         DO I = 1, N
            IF (WT(I).LE.ZERO) RETURN
         ENDDO
      ENDIF
      IFAIL = 3
      DO I = 1, N - 1
         IF (X(I).GE.X(I + 1)) RETURN
      ENDDO
C
C IFAIL = 10 if failure to allocate
C      
      IFAIL = 10
      IER = 0
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IER)
      IF (IER.NE.0) RETURN 
      I = N
      ALLOCATE (W(I), STAT = IER)
      IF (IER.NE.0) RETURN  
         
      IF (WEIGHT_SAV.EQ.'W') THEN
         DO I = 1, N
            W(I) = ONE/SQRT(WT(I))
         ENDDO
      ELSE
         DO I = 1, N
            W(I) = ONE
         ENDDO
      ENDIF            
C
C Call my edited version of CUBGCV with IER = 1 (this is vital)
C
      VAR = RHO
      JOB = 1
      IER = 1
      
      CALL CUBGCV (X, Y, W, N, YHAT, C, LDC, VAR, JOB, H, WK, IER) 

      IFAIL = IER
      IF (IFAIL.EQ.0) THEN
C
C Success so define DF, RSS, and RES
C        
         DF = WK(2)
         RSS = ZERO
         DO I = 1, N
            RES(I) = (Y(I) - YHAT(I))/W(I)
            RSS = RSS + RES(I)**2
         ENDDO  
      ENDIF    
      DEALLOCATE (W, STAT = IER)
      END
C
C


