
C 
C Action: SIMFIT version of G10ACF 
C Author: w.g.bardsley, university of manchester, u.k., 30/10/2012
C
C This substitute for G10ACF has three limitations as follows:
C 1) It only accepts METHOD = 'G' 
C 2) It requires that ACM642 = CUBGCV be edited at several places 
C 3) It requires IER to be set on entry to CUBGCV to allow for future
C    developments with METHOD = 'C' and 'D' 
C I intend to eventually to allow other values of METHOD   
C
      SUBROUTINE G10ACF$(METHOD, WEIGHT, N, X, Y, WT, YHAT, C, LDC,
     +                   RSS, DF, RES, H, CRIT, RHO, U, TOL, MAXCAL, WK,
     +                   IFAIL)
      IMPLICIT NONE
C
C Arguments
C  
      INTEGER N, LDC, MAXCAL, IFAIL
      DOUBLE PRECISION X(N), Y(N), WT(*), YHAT(N), C(LDC,3), RSS,
     +                 DF, RES(N), H(N), CRIT, RHO, U, TOL,
     +                 WK(7*(N + 2))
      CHARACTER (LEN = 1) METHOD, WEIGHT
C
C Allocatable
C 
      DOUBLE PRECISION, ALLOCATABLE :: W(:)     
C
C Locals
C
      INTEGER I, IER, JOB
      DOUBLE PRECISION VAR
      DOUBLE PRECISION ZERO, ONE, TWO, EPSI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           EPSI = 1.0D-07) 
      CHARACTER (LEN = 1) METHOD_SAV, WEIGHT_SAV   
      
      EXTERNAL CUBGCV
      INTRINSIC SQRT, DBLE

      IFAIL = 1
      IF (N.LT.3 .OR. LDC.LT.N - 1) RETURN  
      IF (METHOD.EQ.'C' .OR. METHOD.EQ.'c') THEN
         METHOD_SAV = 'C'
      ELSEIF (METHOD.EQ.'G' .OR. METHOD.EQ.'g') THEN
         METHOD_SAV = 'G'
      ELSEIF (METHOD.EQ.'D' .OR. METHOD.EQ.'d') THEN
         METHOD_SAV = 'D'
      ELSE
         METHOD_SAV = 'X'   
      ENDIF
      IF (METHOD_SAV.NE.'C' .AND.
     +    METHOD_SAV.NE.'G' .AND.
     +    METHOD_SAV.NE.'D') RETURN
      IF (METHOD_SAV.EQ.'D' .AND. CRIT.LE.TWO .OR.
     +    METHOD_SAV.EQ.'D' .AND. CRIT.GT.DBLE(N)) RETURN  
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         WEIGHT_SAV = 'W'
      ELSEIF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         WEIGHT_SAV = 'U'
      ELSE
         RETURN
      ENDIF 
      IF (TOL.LT.EPSI .OR.
     +    U.LE.TOL    .OR.
     +    MAXCAL.LT.3) RETURN   
      IFAIL = 2 
      IF (WEIGHT_SAV.EQ.'W') THEN 
         DO I = 1, N
            IF (WT(I).LE.ZERO) RETURN
         ENDDO
      ENDIF
      IFAIL = 3
      DO I = 1, N - 1
         IF (X(I).GE.X(I + 1)) RETURN
      ENDDO
C
C IFAIL = 10 if failure to allocate
C      
      IFAIL = 10
      IER = 0
      IF (ALLOCATED(W)) DEALLOCATE(W, STAT = IER)
      IF (IER.NE.0) RETURN 
      I = N
      ALLOCATE (W(I), STAT = IER)
      IF (IER.NE.0) RETURN   
      IF (WEIGHT_SAV.EQ.'W') THEN
         DO I = 1, N
            W(I) = ONE/SQRT(WT(I))
         ENDDO
      ELSE
         DO I = 1, N
            W(I) = ONE
         ENDDO
      ENDIF            

      IF (METHOD_SAV.EQ.'G') THEN
         VAR = - ONE
      ELSE   
         IFAIL = 100
         RETURN 
      ENDIF
C
C Call my edited version of CUBGCV with IER = 0 (this is vital)
C      
      JOB = 1
      IER = 0
      
      CALL CUBGCV (X, Y, W, N, YHAT, C, LDC, VAR, JOB, H, WK, IER) 

      
      IFAIL = IER
      IF (IFAIL.EQ.0) THEN
C
C Success so define DF, RHO, RSS, and RES
C        
         DF = WK(2)
         RHO = WK(1)/(ONE - WK(1))
         RSS = ZERO
         DO I = 1, N
            RES(I) = (Y(I) - YHAT(I))/W(I)
            RSS = RSS + RES(I)**2
         ENDDO  
      ENDIF 
      DEALLOCATE (W, STAT = IER)   
      END
C
C 
     


