C
C Action: Simfit substitute for G10BAF based on AS176
C Author: w.g.bardsley, university of manchester, u.k., 20/10/2012
C
C 30/10/2012 now returns IFAIL = (10 + IFAULT) if failure occurs in APS176
C            and also requires NS = 2**K for call to APS176     
C
      SUBROUTINE G10BAF$(N, X, WINDOW, SLO, SHI, NS, SMOOTH, T, USEFFT,
     +                   FFT, IFAIL)
      IMPLICIT   NONE     
C
C Arguments
C
      INTEGER    N, NS, IFAIL
      DOUBLE PRECISION X(N), WINDOW, SLO, SHI, SMOOTH(NS), T(NS),
     +                 FFT(NS)
      LOGICAL    USEFFT
C
C Locals
C      
      INTEGER    I, ICAL, IFAULT
      DOUBLE PRECISION DELTA, XBOT, XTOP
      DOUBLE PRECISION ZERO, HALF, THREE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, THREE = 3.0D+00)
      LOGICAL    READY
      EXTERNAL   APS176
      INTRINSIC  DBLE
      SAVE       READY
      DATA       READY / .FALSE. /
      IFAIL = 1
      IF (N.LE.0 .OR.
     +    NS.LT.2 .OR.
     +    SHI.LE.SLO .OR.
     +    WINDOW.LE.ZERO) RETURN 
      IFAIL = 2
      IF (USEFFT) THEN
        IF (.NOT.READY) RETURN
        ICAL = 1  
      ELSE
         ICAL = 0
      ENDIF  
      IFAIL = 4
      XBOT = X(1)
      XTOP = X(1)
      DO I = 2, N
         IF (X(I).LT.XBOT) THEN
            XBOT = X(I)
         ELSEIF (X(I).GT.XTOP) THEN
            XTOP = X(I)
         ENDIF
      ENDDO 
      IF (XBOT - THREE*WINDOW.LT.SLO .OR.
     +    XTOP + THREE*WINDOW.GT.SHI) RETURN 
              
      CALL APS176(X, N, SLO, SHI, WINDOW, FFT, SMOOTH, NS, ICAL, IFAULT)
      
      IF (IFAULT.NE.0) THEN
         IFAIL = 10 + IFAULT
         READY = .FALSE.
      ELSE
         IFAIL = 0
         READY = .TRUE.
         DELTA = (SHI - SLO)/DBLE(NS)
         DO I = 1, NS
            T(I) = SLO + (DBLE(I) - HALF)*DELTA
         ENDDO  
      ENDIF
      END               