C
C
      SUBROUTINE G10ZAF$(WEIGHT, N, X, Y, WT, NORD, XORD, YORD, WTORD,
     +                   RSS, IWRK, IFAIL)
C
C ACTION: Substitute for NAG routine G10ZAF
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 26/09/2005
C
C Note: this version is not optimised for speed or acuuracy and IWRK is not
C       referenced. At some stage I should implement the West method but
C       for now it works OK.
C
      IMPLICIT   NONE
      INTEGER    N, NORD, IWRK(N), IFAIL
      INTEGER    I, J, NPTS, NREPS
      DOUBLE PRECISION X(N), Y(N), WT(*), XORD(N), YORD(N), WTORD(N),
     +                 RSS
      DOUBLE PRECISION SUMW, SUMY
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  WEIGHT*1
      EXTERNAL   ABCSRT
C
C Is it safe ?
C
      IWRK(1) = 0!to silence ftn95
      IFAIL = 0
      RSS = ZERO
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w' .OR.
     +    WEIGHT.EQ.'U' .or. WEIGHT.EQ.'u') THEN
         IF (N.LT.1) THEN
            IFAIL = 1
            RETURN
         ENDIF
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         NPTS = 0
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ELSEIF (WT(I).GT.ZERO) THEN
               NPTS = NPTS + 1
               XORD(NPTS) = X(I)
               YORD(NPTS) = Y(I)
               WTORD(NPTS) = WT(I)
            ENDIF
         ENDDO
         IF (NPTS.EQ.0) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ELSE
         NPTS = N
         DO I = 1, N
            XORD(I) = X(I)
            YORD(I) = Y(I)
            WTORD(I) = ONE
         ENDDO
      ENDIF
C
C Put into order
C
      CALL ABCSRT (NPTS, XORD, YORD, WTORD)
C
C Process
C
      RSS = ZERO
      NORD = 0
      DO I = 1,  NPTS
         IF (I.EQ.1) THEN
C
C First time so start a group
C
            NREPS = 1
            SUMW = WTORD(1)
         ELSEIF (I.EQ.NPTS) THEN
            IF (XORD(NPTS).GT.XORD(NPTS - 1)) THEN
C
C Last point is a new value so first add up the previous group
C
               IF (NREPS.GT.1) THEN
                  SUMY = ZERO
                  DO J = I - NREPS, I - 1
                     SUMY = SUMY + WTORD(J)*YORD(J)
                  ENDDO
                  SUMY = SUMY/SUMW
                  DO J = I - NREPS, I - 1
                     RSS = RSS + WTORD(J)*(YORD(J) - SUMY)**2
                  ENDDO
               ELSE
                  SUMY = YORD(I - 1)
               ENDIF
               NORD = NORD + 1
               XORD(NORD) = XORD(I - 1)
               YORD(NORD) = SUMY
               WTORD(NORD) = SUMW
               NORD = NORD + 1
               XORD(NORD) = XORD(I)
               YORD(NORD) = YORD(I)
               WTORD(NORD) = WTORD(I)
            ELSE
C
C Complete the unfinished final group
C
               NREPS = NREPS + 1
               SUMW = SUMW + WTORD(I)
               SUMY = ZERO
               DO J = I - NREPS + 1, I
                  SUMY = SUMY + WTORD(J)*YORD(J)
               ENDDO
               SUMY = SUMY/SUMW
               DO J = I - NREPS + 1, I
                  RSS = RSS + WTORD(J)*(YORD(J) - SUMY)**2
               ENDDO
               NORD = NORD + 1
               XORD(NORD) = XORD(I)
               YORD(NORD) = SUMY
               WTORD(NORD) = SUMW
             ENDIF
         ELSE
            IF (XORD(I).GT.XORD(I - 1)) THEN
C
C Add up for an intermediate group
C
               IF (NREPS.GT.1) THEN
                  SUMY = ZERO
                  DO J = I - NREPS, I - 1
                     SUMY = SUMY + WTORD(J)*YORD(J)
                  ENDDO
                  SUMY = SUMY/SUMW
                  DO J = I - NREPS, I - 1
                     RSS = RSS + WTORD(J)*(YORD(J) - SUMY)**2
                  ENDDO
               ELSE
                  SUMY = YORD(I - 1)
               ENDIF
               NORD = NORD + 1
               XORD(NORD) = XORD(I - 1)
               YORD(NORD) = SUMY
               WTORD(NORD) = SUMW
               NREPS = 1
               SUMW = WTORD(I)
            ELSE
C
C Increment an ongoing group
C
               NREPS = NREPS + 1
               SUMW = SUMW + WTORD(I)
            ENDIF
         ENDIF
      ENDDO
      END
C
C
