C
C
      SUBROUTINE G11CAF$(N, M, NS, Z, LDZ, ISZ, IP, IC, ISI, DEV, B,
     +                   SE, SC, COV, NCA, NCT, TOL, MAXIT, IPRINT, WK,
     +                   LWK, IFAIL)
C
C ACTION: version of G11CAF calling APS196
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 13/08/2002
C         15/01/2006 introduced allocatable workspace
C
C         Additional IFAIL exits as follows:
C
C         IFAIL = 7: IP + NS too large
C         IFAIL = 8: dimensions incorrect in APS196
C         ifail = 10: failure to allocate workspace
C
      IMPLICIT NONE
C
C Variables in argument list
C
      INTEGER  IP, LDZ, M, N, NS
      INTEGER  ISZ(M), IC(N), ISI(N), NCA(NS), NCT(NS), MAXIT, IPRINT,
     +         LWK, IFAIL
      DOUBLE PRECISION Z(LDZ,M), DEV, B(IP), SE(IP), SC(IP),
     +                 COV(IP*(IP + 1)/2), TOL, WK(LWK)
C
C Local variables
C NIMAX = second dimension of Z, i.e. max. no. cases
C NMAX = max. no. cases  plus controls in any strata
C NMAX1 = NMAX + 1
C NVMAX = max. no. variables
C NVMAX1 = NVMAX(NVMAX + 1)/2
C NV = no. variables to be estimated
C NBIG = max. no. of variables plus strata
C
      INTEGER    NIMAX, NMAX, NMAX1, NVMAX, NVMAX1, NV, NV1
      INTEGER    NBIG
      INTEGER, ALLOCATABLE :: IVAR(:)
      INTEGER    I, ICOUNT, IERR, IFAULT, IFSAV, J, K, L, N0
      INTEGER    JCASE, JCONT, NCASE, NCONT
      INTEGER    I1, I2, I3, I4, I5, I6, I7, I8, I9, I10
      DOUBLE PRECISION CHI2, ST
      DOUBLE PRECISION TOL1, ZERO
      PARAMETER (TOL1 = 1.0D-12, ZERO = 0.0D+00)
      EXTERNAL   APS196
      INTRINSIC  ABS, SQRT
C
C Is it safe ?
C
      IFAIL = 0
      DEV = ZERO
      DO I = 1, IP
        SE(I) = ZERO
      ENDDO
      IF (M.LT.1 .OR. N.LT.2 .OR. NS.LT.1 .OR. IP.LT.1 .OR.
     +    LDZ.LT.N .OR. TOL.LT.TOL1 .OR. MAXIT.LT.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
      ICOUNT = 0
      DO I = 1, M
         IF (ISZ(I).LT.0) THEN
            IFAIL = 2
            RETURN
         ENDIF
         IF (ISZ(I).GT.0) ICOUNT = ICOUNT + 1
      ENDDO
      IF (ICOUNT.NE.IP) THEN
         IFAIL = 2
         RETURN
      ENDIF
      N0 = 0
      DO I = 1, N
         IF (IC(I).LT.0 .OR. IC(I).GT.1) THEN
            IFAIL = 2
            RETURN
         ENDIF
         IF (ISI(I).LT.0 .OR. ISI(I).GT.NS) THEN
            IFAIL = 2
            RETURN
         ENDIF
         IF (ISI(I).GT.0) N0 = N0 + 1
      ENDDO
      IF (IP.GE.N0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IFSAV = IFAIL
      IFAIL = 10
      NBIG = IP + NS + 1
      IF (ALLOCATED(IVAR)) DEALLOCATE(IVAR, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IVAR(NBIG), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Define NIMAX
C
      NIMAX = N0
C
C Input data seems OK but check for sufficient local space for variables
C
      IF (IP + NS.GT.NBIG) THEN
         IFAIL = 7
         DEALLOCATE(IVAR, STAT = IERR)
         RETURN
      ENDIF
C
C Step 1: calculate NCA and NCT then NMAX and NMAX1
C =======
C
      DO I = 1, NS
         NCA(I) = 0
         NCT(I) = 0
      ENDDO
      DO I = 1, N
         ICOUNT = ISI(I)
         IF (ICOUNT.GT.0) THEN
            IF (IC(I).EQ.0) THEN
               NCA(ICOUNT) = NCA(ICOUNT) + 1
            ELSE
               NCT(ICOUNT) = NCT(ICOUNT) + 1
            ENDIF
         ENDIF
      ENDDO
      NMAX = 0
      DO I = 1, NS
         ICOUNT = NCA(I) + NCT(I)
         IF (ICOUNT.GT.NMAX) NMAX = ICOUNT
      ENDDO
      NMAX1 = NMAX + 1
      ICOUNT = IP*N0 + (NMAX + 1)*(IP + 1)*(IP + 2)/2 + NMAX
      IF (LWK.LT.ICOUNT) THEN
         IFAIL = 3
         DEALLOCATE(IVAR, STAT = IERR)
         RETURN
      ENDIF
C
C Step 2: Calculate Z for AS196 and store columnwise in WK
C ======
C
      NCASE = 0
      NCONT = NCASE + NCA(1)
      DO K = 1, NS
         JCASE = NCASE
         JCONT = NCONT
         DO L = 1, N
            IF (ISI(L).EQ.K) THEN
C
C An item from case K has been encountered so determine if it is a case or a control
C
               IF (IC(L).EQ.0) THEN
                  JCASE = JCASE + 1
                  J = JCASE
               ELSE
                  JCONT = JCONT + 1
                  J = JCONT
               ENDIF
               IF (J.GT.NIMAX) THEN
                  IFAIL = 9
                  DEALLOCATE(IVAR, STAT = IERR)
                  RETURN
               ENDIF
C
C Load the data into WK which will be supplied to APS196 as Z
C
               ICOUNT = 0
               DO I = 1, M
                  IF (ISZ(I).GT.0) THEN
                     ICOUNT = ICOUNT + 1
C
C**************************************
C Note that Z_APS196(ICOUNT,J) = Z(L,I)
C**************************************
C
                     WK(ICOUNT + (J - 1)*IP) = Z(L,I)
                  ENDIF
               ENDDO
            ENDIF
         ENDDO
         IF (K.LT.NS) THEN
            NCASE = NCASE + NCA(K) + NCT(K)
            NCONT = NCASE + NCA(K + 1)
         ENDIF
      ENDDO
C
C Step 3: Assign IVAR then partition WK and call APS196
C
      DO I = 1, IP
         IVAR(I) = I
      ENDDO
      NVMAX = IP
      NVMAX1 = NVMAX*(NVMAX + 1)/2
      NV = IP
C ... INS starts in IVAR at NV1
      NV1 = NV + 1
C ... Z starts in WK at I1
      I1 = 1
C ... COVI starts in WK at I2
      I2 = I1 + NIMAX*NVMAX
C ... CNTR starts in WK at I3
      I3 = I2 + NVMAX1
C ... W starts in WK at I4
      I4 = I3 + NS*NVMAX
C ... WB starts in WK at I5
      I5 = I4 + NVMAX
C ... WDB starts in WK at I6
      I6 = I5 + NMAX1
C ... WDB2 starts in WK at I7
      I7 = I6 + NVMAX*NMAX1
C ... U starts in WK at I8
      I8 = I7 + NVMAX1*NMAX1
C ... DB starts in WK at I9
      I9 = I8 + NMAX
C ... D2B starts in WK at I10
      I10 = I9 + NVMAX
C
C Check that LWK is large enough
C
      IF (I10 + NVMAX1.GT.LWK) THEN
         IFAIL = 3
         DEALLOCATE(IVAR, STAT = IERR)
         RETURN
      ENDIF
      IFAULT = 0
      CALL APS196 (NS, NCA, NCT, NIMAX, NMAX, NMAX1, NVMAX, NVMAX1, NV,
     +             WK(I1), IVAR(I1), WK(I2), WK(I3), WK(I4), WK(I5),
     +             WK(I6), WK(I7), WK(I8), IVAR(NV1), WK(I9), WK(I10),
     +             SC, B, COV, CHI2, ST, IFAULT, IPRINT, MAXIT, TOL)
C
C Check IFAULT
C
      IF (IFAULT.EQ.1) THEN
         IFAIL = 8
      ELSEIF (IFAULT.EQ.2) THEN
         IFAIL = 5
      ELSEIF (IFAULT.EQ.3) THEN
         IFAIL = 6
      ELSE
         IFAIL = 0
      ENDIF
C
C Define DEV = COVI(1), then calculate standard errors
C
      DEV = WK(NVMAX*NIMAX + 1)
      DO I = 1, IP
         ICOUNT = I*(I - 1)/2 + I
         IF (COV(ICOUNT).GT.ZERO) THEN
            SE(I) = SQRT(COV(ICOUNT))
         ELSE
            SE(I) = ABS(B(I))
         ENDIF
      ENDDO
C
C Note: Return CHI2 and ST in WK(1) and WK(2) ... this is not a NAG feature
C
      WK(1) = CHI2
      WK(2) = ST
C
C Deallocate workspace
C
      DEALLOCATE(IVAR, STAT = IERR)
      END
C
C
