C
C Requires INDEXX$ to return a sorting index
C ==========================================
C
      SUBROUTINE G12AAF$(N, T, IC, FREQ, IFREQ, ND, TP, P, PSIG,
     +                   IWK, IFAIL)
C
C ACTION : subsitute for the NAG routine but IFAIL not tested on input
C          Calls INDEXX$ to return a sorting index in IWK
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/8/98
C
C          NJ = sample size at failure time
C          NDJ = current failures
C          NDJ1 = failure count
C          NDJ2 = censorship count
C          J = current position in discrete list
C          K = current data in order
C          TEST = current threshold
C          TESTK = current datum point
C
      IMPLICIT  NONE
      INTEGER   N, IC(N), IFREQ(*), ND, IWK(N), IFAIL
      INTEGER   I, J, K, NJ, NDJ, NDJ1, NDJ2
      DOUBLE PRECISION P(N), PSIG(N), T(N), TP(N)
      DOUBLE PRECISION SHAT, TEST, TESTJ, TESTK, VHAT, VSUM
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER FREQ*(*)
      CHARACTER C*1
      LOGICAL   USE1
      EXTERNAL  INDEXX$
      INTRINSIC DBLE, SQRT
C
C======================================================================
C Assign IFAIL and check the input
C======================================================================
C
      IFAIL = 0

      IF (N.LT.2) THEN
C...is N > 2 ?
         IFAIL = 1
         RETURN
      ENDIF

C...is C = F or S ?
      C = FREQ(1:1)
      IF (C.EQ.'F' .OR. C.EQ.'f') THEN
         USE1 = .TRUE.
      ELSEIF (C.EQ.'S' .OR. C.EQ.'s') THEN
         USE1 = .FALSE.
      ELSE
         IFAIL = 2
         RETURN
      ENDIF

C...is IC = 0 or 1 ?
      DO I = 1, N
         IF (IC(I).LT.0 .OR. IC(I).GT.1) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDDO

C...is FREQ >= 0 ?
      IF (USE1) THEN
         DO I = 1, N
            IF (IFREQ(I).LT.0) THEN
               IFAIL = 4
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C======================================================================
C Get the index array
C======================================================================
C
      CALL INDEXX$(N, T, IWK)
C
C======================================================================
C Define ND and TP ... the number of discrete points with a FAILURE
C======================================================================
C
      ND = 0
      J = IWK(1)
      TEST = T(J) - ONE
      IF (USE1) THEN
         DO I = 1, N
            J = IWK(I)
            TESTJ = T(J)
            IF (TESTJ.GT.TEST .AND. IC(J).EQ.0 .AND. IFREQ(J).GT.0) THEN
               ND = ND + 1
               TP(ND) = TESTJ
               TEST = TESTJ
            ENDIF
         ENDDO
      ELSE
         DO I = 1, N
            J = IWK(I)
            TESTJ = T(J)
            IF (TESTJ.GT.TEST .AND. IC(J).EQ.0) THEN
               ND = ND + 1
               TP(ND) = TESTJ
               TEST = TESTJ
            ENDIF
         ENDDO
      ENDIF
C
C\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
C======================================================================
C Work out SHAT, NJ, NDJ, P ... The FREQUENCY case
C======================================================================
C
      IF (USE1) THEN
         NJ = 0
         DO I = 1, N
            NJ = NJ + IFREQ(I)
         ENDDO
         NDJ1 = 0
         NDJ2 = 0
         J = 1
         TEST = TP(J)
         SHAT = ONE
         DO I = 1, N
C
C Set TESTK = T(IWK(I)) then test it for position
C
            K = IWK(I)
            TESTK = T(K)
            IF (IFREQ(K).EQ.0) THEN
C
C Do nothing since IFREQ(K) = 0
C
               IFREQ(K) = 0!to silence ftn95
            ELSEIF (TESTK.LE.TEST .OR. J.EQ.ND) THEN
C
C Increment the counters ... T(k) < TEST at this event
C
               IF (IC(K).EQ.0) THEN
C
C A failure so add it to the failure counter
C
                  NDJ1 = NDJ1 + IFREQ(K)
               ELSEIF (TESTK.LT.TEST) THEN
C
C A censorship before the current failure so remove it from the NJ value
C
                  NJ = NJ - IFREQ(K)
               ELSE
C
C A censorship at the current failure so add it to the next failure counter
C
                  NDJ2 = NDJ2 + IFREQ(K)
               ENDIF
            ELSE
C
C Work out the estimate then re-set the counters ... T(k) >= TEST
C
               NDJ = NDJ1
               IF (NJ.GT.0) THEN
                  SHAT = SHAT*(DBLE(NJ - NDJ))/DBLE(NJ)
                  P(J) = SHAT
               ELSE
                  P(J) = ZERO
               ENDIF
C
C Adjust NJ, NDJ1 and NDJ2 then prepare for the next TEST level
C
               NJ = NJ - NDJ1 - NDJ2
               NDJ1 = 0
               NDJ2 = 0
               J = J + 1
               IF (J.LE.ND) TEST = TP(J)
               IF (IC(K).EQ.0) THEN
C
C The current point is failure so start a new failure counter
C
                  NDJ1 = IFREQ(K)
               ELSEIF (TESTK.LT.TEST) THEN
C
C A censorship at an intermediate value so subtract from NJ
C
                  NJ = NJ - IFREQ(K)
               ELSE
C
C A censorship at the next failure point so start a new censorship counter
C
                  NDJ2 = IFREQ(K)
               ENDIF
            ENDIF
         ENDDO
C
C Set the last estimate
C
         NDJ = NDJ1
         IF (NJ.GT.0) THEN
            SHAT = SHAT*(DBLE(NJ - NDJ))/DBLE(NJ)
            P(ND) = SHAT
         ELSE
            P(ND) = ZERO
         ENDIF
C
C The variances
C
         NJ = 0
         DO I = 1, N
            NJ = NJ + IFREQ(I)
         ENDDO
         NDJ1 = 0
         NDJ2 = 0
         J = 1
         TEST = TP(J)
         VSUM = ZERO
         DO I = 1, N
C
C Set T(IWK(I)) then test it for position
C
            K = IWK(I)
            TESTK = T(K)
            IF (IFREQ(K).EQ.0) THEN
C
C Do nothing
C
               IFREQ(K) = 0!to silence ftn85
            ELSEIF (TESTK.LE.TEST .OR. J.EQ.ND) THEN
C
C Increment the counters ... T(k) < TEST
C
               IF (IC(K).EQ.0) THEN
                  NDJ1 = NDJ1 + IFREQ(K)
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - IFREQ(K)
               ELSE
                  NDJ2 = NDJ2 + IFREQ(K)
               ENDIF
            ELSE
C
C Work out the estimate then re-set the counters ... T(k) >= TEST
C
               NDJ = NDJ1
               IF (NJ.GT.NDJ) THEN
                  VSUM = VSUM + DBLE(NDJ)/(DBLE(NJ)*DBLE(NJ - NDJ))
                  VHAT = P(J)*P(J)*VSUM
                  PSIG(J) = SQRT(VHAT)
               ELSE
                  PSIG(J) = ZERO
               ENDIF
C
C Adjust NJ, NDJ1 and NDJ2 then prepare for the next TEST level
C
               NJ = NJ - NDJ1 - NDJ2
               NDJ1 = 0
               NDJ2 = 0
               J = J + 1
               IF (J.LE.ND) TEST = TP(J)
               IF (IC(K).EQ.0) THEN
                  NDJ1 = IFREQ(K)
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - IFREQ(K)
               ELSE
                  NDJ2 = IFREQ(K)
               ENDIF
            ENDIF
         ENDDO
C
C Set the last estimate
C
         NDJ = NDJ1
         IF (NJ.GT.NDJ) THEN
            VSUM = VSUM + DBLE(NDJ)/(DBLE(NJ)*DBLE(NJ - NDJ))
            VHAT = P(ND)*P(ND)*VSUM
            PSIG(ND) = SQRT(VHAT)
         ELSE
            PSIG(ND) = ZERO
         ENDIF
      ELSE
C
C\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
C======================================================================
C Work out SHAT, NJ, NDJ, P ... The NONFREQUENCY case
C======================================================================
C
         NJ = N
         NDJ1 = 0
         NDJ2 = 0
         J = 1
         TEST = TP(J)
         SHAT = ONE
         DO I = 1, N
C
C Set T(IWK(I)) then test it for position
C
            K = IWK(I)
            TESTK = T(K)
            IF (TESTK.LE.TEST .OR. J.EQ.ND) THEN
C
C Increment the counters ... T(k) < TEST
C
               IF (IC(K).EQ.0) THEN
                  NDJ1 = NDJ1 + 1
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - 1
               ELSE
                  NDJ2 = NDJ2 + 1
               ENDIF
            ELSE
C
C Work out the estimate then re-set the counters ... T(k) >= TEST
C
               NDJ = NDJ1
               IF (NJ.GT.0) THEN
                  SHAT = SHAT*(DBLE(NJ - NDJ))/DBLE(NJ)
                  P(J) = SHAT
               ELSE
                  P(J) = ZERO
               ENDIF
C
C Adjust NJ, NDJ1 and NDJ2 then prepare for the next TEST level
C
               NJ = NJ - NDJ1 - NDJ2
               NDJ1 = 0
               NDJ2 = 0
               J = J + 1
               IF (J.LE.ND) TEST = TP(J)
               IF (IC(K).EQ.0) THEN
                  NDJ1 = 1
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - 1
               ELSE
                  NDJ2 = 1
               ENDIF
            ENDIF
         ENDDO
C
C Set the last estimate
C
         NDJ = NDJ1
         IF (NJ.GT.0) THEN
            SHAT = SHAT*(DBLE(NJ - NDJ))/DBLE(NJ)
            P(ND) = SHAT
         ELSE
            P(ND) = ZERO
         ENDIF
C
C The variances
C
         NJ = N
         NDJ1 = 0
         NDJ2 = 0
         J = 1
         TEST = TP(J)
         VSUM = ZERO
         DO I = 1, N
C
C Set T(IWK(I)) then test it for position
C
            K = IWK(I)
            TESTK = T(K)
            IF (TESTK.LE.TEST .OR. J.EQ.ND) THEN
C
C Increment the counters ... T(k) < TEST
C
               IF (IC(K).EQ.0) THEN
                  NDJ1 = NDJ1 + 1
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - 1
               ELSE
                  NDJ2 = NDJ2 + 1
               ENDIF
            ELSE
C
C Work out the estimate then re-set the counters ... T(k) >= TEST
C
               NDJ = NDJ1
               IF (NJ.GT.NDJ) THEN
                  VSUM = VSUM + DBLE(NDJ)/(DBLE(NJ)*DBLE(NJ - NDJ))
                  VHAT = P(J)*P(J)*VSUM
                  PSIG(J) = SQRT(VHAT)
               ELSE
                  PSIG(J) = ZERO
               ENDIF
C
C Adjust NJ, NDJ1 and NDJ2 then prepare for the next TEST level
C
               NJ = NJ - NDJ1 - NDJ2
               NDJ1 = 0
               NDJ2 = 0
               J = J + 1
               IF (J.LE.ND) TEST = TP(J)
               IF (IC(K).EQ.0) THEN
                  NDJ1 = 1
               ELSEIF (TESTK.LT.TEST) THEN
                  NJ = NJ - 1
               ELSE
                  NDJ2 = 1
               ENDIF
            ENDIF
         ENDDO
C
C Set the last estimate
C
         NDJ = NDJ1
         IF (NJ.GT.NDJ) THEN
            VSUM = VSUM + DBLE(NDJ)/(DBLE(NJ)*DBLE(NJ - NDJ))
            VHAT = P(J)*P(J)*VSUM
            PSIG(ND) = SQRT(VHAT)
         ELSE
            PSIG(ND) = ZERO
         ENDIF
      ENDIF
      END
C
C
      SUBROUTINE INDEXX$(N, ARRIN, INDX)
C
C Sort ARRIN and write the index array INDX
C
      IMPLICIT  NONE
      INTEGER   N, INDX(N)
      INTEGER   I, INDXT, IR, J, L
      DOUBLE PRECISION ARRIN(N)
      DOUBLE PRECISION Q
      DO J = 1, N
         INDX(J) = J
      ENDDO
      L = N/2 + 1
      IR = N
10    CONTINUE
         IF(L.GT.1)THEN
            L = L - 1
            INDXT = INDX(L)
            Q = ARRIN(INDXT)
         ELSE
            INDXT = INDX(IR)
            Q = ARRIN(INDXT)
            INDX(IR) = INDX(1)
            IR = IR - 1
            IF (IR.EQ.1) THEN
               INDX(1) = INDXT
               RETURN
             ENDIF
         ENDIF
         I = L
         J = L + L
20       IF (J.LE.IR) THEN
            IF (J.LT.IR) THEN
               IF (ARRIN(INDX(J)).LT.ARRIN(INDX(J + 1))) J = J + 1
            ENDIF
            IF (Q.LT.ARRIN(INDX(J))) THEN
               INDX(I) = INDX(J)
               I = J
               J = J + J
            ELSE
               J = IR + 1
            ENDIF
            GOTO 20
         ENDIF
         INDX(I) = INDXT
      GOTO 10
      END
C
C
