
C
C Simfit version of G12BAF: w.g.bardsley, university of manchester, u.k., 20/04/2013 
C
C Note as follows about this version:
C 1) It does not support an offset yet and returns IFAIL = 10 if an offset is requested
C 2) It calls G12ZAF and G11CAF and so treats ties exactly
C 3) As it treats ties exactly it can give different results from G12BAF 
C 4) So it is more accurate than NAG G12BAF but uses much more work space
C 5) To avoid ambiguity with weights and suppressed variables, the pre-processing
C    required by ISZ and ISI is done using a dummy data set Y with all ISY = 1 before calling G12ZAF 
C    and G11CAF, so that these can be called with no requirement for data or variable suppression
C 6) Scores returned from G11CAF$ do not agree closely with those from G12BAF
C
      SUBROUTINE G12BAF$(OFFSET, N, M, NS, Z, LDZ, ISZ, IP, T, IC,
     +                   OMEGA, ISI, DEV, B, SE, SC, COV, RES, ND,
     +                   TP, SUR, NDMAX, TOL, MAXIT, IPRINT, WK,
     +                   IWK, IFAIL)
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER IP, LDZ, M, N, NDMAX
      INTEGER NS, ISZ(M), IC(N), ISI(*), ND, MAXIT, IPRINT
      INTEGER IWK(2*N), IFAIL
      DOUBLE PRECISION Z(LDZ,M), T(N), OMEGA(*), TOL
      DOUBLE PRECISION B(IP), DEV, SE(IP), SC(IP),
     +                 COV(IP*(IP + 1)/2), RES(N),
     +                 TP(NDMAX), SUR(NDMAX,*),
     +                 WK(IP*(IP + 9)/2 + N)
      CHARACTER (LEN = 1) OFFSET
C
C Allocatables
C      
      INTEGER,          ALLOCATABLE :: ICY(:), ID(:), ISIY(:), ISY(:),
     +                                 IXS(:), NCA(:), NCM(:), NCT(:)
      DOUBLE PRECISION, ALLOCATABLE :: WORK(:), TY(:), X(:,:), Y(:,:)
C
C Locals
C   
      INTEGER    I, ICOUNT, IERR, J, JCOUNT, LWORK, NMAX, NMAX1, N0
      INTEGER    LDY, MXN, MY, NPTS, NUM, NXS
      INTEGER    I1, I2, I3, I4, I5, I6, I7, I8, I9, I10,
     +           NIMAX, NVMAX, NVMAX1  
      DOUBLE PRECISION DN, ZBAR
      DOUBLE PRECISION TOLMIN, ZERO
      PARAMETER (TOLMIN = 1.0D-12, ZERO = 0.0D+00) 
      EXTERNAL   G12ZAF$, G11CAF$
      EXTERNAL   G12BAF$_AUX
      INTRINSIC  MAX   
C
C Is it safe ?
C      
      IFAIL = 0
      IF (OFFSET.EQ.'Y' .OR.OFFSET.EQ.'y') THEN
         WK(1) = OMEGA(1)!to silence ftn95
         IFAIL = 10
         RETURN
      ELSEIF (OFFSET.NE.'N' .AND. OFFSET.NE.'n') THEN
         IFAIL = 1
         RETURN
      ENDIF    
      IF (M.LT.1 .OR. N.LT.2 .OR. NS.LT.0 .OR. LDZ.LT.N .OR. 
     +    TOL.LT.TOLMIN .OR. MAXIT.LT.0) THEN
         IFAIL = 1
         RETURN
      ENDIF  
      ICOUNT = 0
      DO I = 1, M
         IF (ISZ(I).LT.0) THEN
            IFAIL = 2
            RETURN
         ELSEIF(ISZ(I).GT.0) THEN
            ICOUNT = ICOUNT + 1   
         ENDIF   
      ENDDO 
      IF (ICOUNT.NE.IP) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (NS.GT.0) THEN
         ICOUNT = 0
         JCOUNT = 0
         DO I = 1, N
            IF (ISI(I).LT.0 .OR. ISI(I).GT.NS) THEN
               IFAIL = 2
               RETURN
            ELSEIF (ISI(I).GT.0) THEN
               ICOUNT = ICOUNT + 1
               IF (IC(I).EQ.1) JCOUNT = JCOUNT + 1
            ENDIF  
         ENDDO   
         IF (ICOUNT.EQ.JCOUNT .OR. IP.GE.ICOUNT) THEN
            IFAIL = 2
            RETURN
         ENDIF 
      ENDIF 
C
C Initialise
C      
      DEV = ZERO
      DO I = 1, IP
         SE(I) = ZERO
         SC(I) = ZERO
      ENDDO   
      DO I = 1, IP*(IP + 1)/2
         COV(I) = ZERO
      ENDDO   
      DO I = 1, N
         RES(I) = ZERO
      ENDDO   
      DO I = 1, NDMAX
         TP(I) = ZERO
         DO J = 1, MAX(1,NS)
            SUR(I,J) = ZERO
         ENDDO
      ENDDO      
C
C Make copies for Y = Z, ISIY = ISZ and ICY = IC to avoid ambiguity between G12ZAF and G11CAF
C  
      IERR = 0
      IF (ALLOCATED(ICY)) DEALLOCATE (ICY, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -101
         RETURN 
      ENDIF  
      IF (ALLOCATED(ISIY)) DEALLOCATE (ISIY, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -102
         RETURN 
      ENDIF  
      IF (ALLOCATED(ISY)) DEALLOCATE (ISY, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -103
         RETURN 
      ENDIF 
      IF (ALLOCATED(TY)) DEALLOCATE (TY, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -104
         RETURN 
      ENDIF 
      IF (ALLOCATED(Y)) DEALLOCATE (Y, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -105
         RETURN 
      ENDIF 
      LDY = N
      ALLOCATE (ICY(LDY), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -106
         GOTO 20 
      ENDIF
      ALLOCATE (ISIY(LDY), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -107
         GOTO 20 
      ENDIF 
      J = IP
      ALLOCATE (ISY(J), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -108
         GOTO 20 
      ENDIF
      ALLOCATE (TY(LDY), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -109
         GOTO 20 
      ENDIF
      ALLOCATE (Y(LDY,J), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = -110
         GOTO 20 
      ENDIF 
C
C Copy Z in to Y centralised and with suppressions taken care of
C
      IF (NS.EQ.0) THEN
         NPTS = N
         DN = DBLE(N)
         JCOUNT = 0
         DO J = 1, M
            IF (ISZ(J).GT.0) THEN
               ZBAR = ZERO
               JCOUNT = JCOUNT + 1
               DO I = 1, NPTS
                  ZBAR = ZBAR + Z(I,J)
               ENDDO 
               ZBAR = ZBAR/DN 
               DO I = 1, NPTS
                  Y(I,JCOUNT) =  Z(I,J) - ZBAR
               ENDDO   
            ENDIF   
         ENDDO
         DO I = 1, NPTS
            TY(I) = T(I)
            ISIY(I) = 1
            ICY(I) = IC(I)
         ENDDO  
      ELSE
         JCOUNT = 0
         DO J = 1, M
            IF (ISZ(J).GT.0) THEN
               JCOUNT = JCOUNT + 1
               ZBAR = ZERO
               NPTS = 0
               DO I = 1, N
                  IF (ISI(I).GT.0) THEN
                     NPTS = NPTS + 1
                     ZBAR = ZBAR + Z(I,J)
                  ENDIF   
               ENDDO 
               DN = DBLE(NPTS)
               ZBAR = ZBAR/DN
               DO I = 1, NPTS
                  Y(I,JCOUNT) = Z(I,J) - ZBAR
               ENDDO     
            ENDIF   
         ENDDO
         NPTS = 0
         DO I = 1, N
            IF (ISI(I).GT.0) THEN
               NPTS = NPTS + 1
               ISIY(NPTS) = ISI(I)
               TY(NPTS) = T(I)
               ICY(I) = IC(I)
            ENDIF   
         ENDDO
      ENDIF 
      DO I = 1, IP
         ISY(I) = 1
      ENDDO    
C
C Guess MXN then call G12ZAF (possibly twice if more workspace is required)
C  
      MXN = MAX(1000,NPTS)
      ICOUNT = 0
      LOOP_I: DO I = 1, 2
         ICOUNT = ICOUNT + 1
         IERR = 0
         IF (ALLOCATED(IXS)) DEALLOCATE(IXS, STAT = IERR)
         IF (IERR.NE.0) THEN
            IFAIL = 101
            GOTO 20
         ENDIF     
         IF (ALLOCATED(ID)) DEALLOCATE(ID, STAT = IERR)
         IF (IERR.NE.0) THEN
            IFAIL = 102
            GOTO 20
         ENDIF       
         IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
         IF (IERR.NE.0) THEN
            IFAIL = 103
            GOTO 20
         ENDIF        
         ALLOCATE (IXS(MXN), STAT = IERR)  
         IF (IERR.NE.0) THEN
            IFAIL = 104 
            GOTO 20
         ENDIF    
         ALLOCATE (ID(MXN), STAT = IERR)  
         IF (IERR.NE.0) THEN
            IFAIL = 105 
            GOTO 20
         ENDIF
         J = IP
         ALLOCATE (X(MXN,J), STAT = IERR)  
         IF (IERR.NE.0) THEN
            IFAIL = 106 
            GOTO 20
         ENDIF 
C
C Call to G12ZAF ... IWK(I) = IRS(i), i = 1, 2, ..., NPTS
C      
         MY = IP
         IFAIL = -1
         CALL G12ZAF$(NPTS, MY, NS, Y, LDY, ISY, IP, TY, ICY, ISIY, NUM,
     +                IXS, NXS, X, MXN, ID, ND, TP, IWK, IFAIL)
          
         IF (ND.GT.NDMAX) THEN
            IFAIL = 2
            GOTO 20
         ENDIF   
         IF (IFAIL.EQ.0)THEN
            EXIT LOOP_I
         ELSEIF (IFAIL.EQ.3 .AND. ICOUNT.LE.1) THEN
C
C Try again with MXN = NUM
C         
            MXN = NUM
         ELSE 
            GOTO 20
         ENDIF
      ENDDO LOOP_I
      
      IERR = 0
      IF (ALLOCATED(NCA)) DEALLOCATE(NCA, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 201
         GOTO 20
      ENDIF
      IF (ALLOCATED(NCM)) DEALLOCATE(NCM, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 202
         GOTO 20
      ENDIF   
      IF (ALLOCATED(NCT)) DEALLOCATE(NCT, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 203
         GOTO 20
      ENDIF   
      I = NXS    
      ALLOCATE(NCA(I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 204
         GOTO 20
      ENDIF
      ALLOCATE(NCM(I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 205
         GOTO 20
      ENDIF
      ALLOCATE(NCT(I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 206
         GOTO 20
      ENDIF
C
C Calculate N0 and NMAX
C 
      
      N0 = NUM
       
      DO I = 1, NXS
         NCM(I) = 0
      ENDDO

      DO I = 1, NUM
         NCM(IXS(I)) = NCM(IXS(I)) + 1
      ENDDO

      NMAX = 0

      DO I = 1, NXS
         IF (NCM(I).GT.NMAX) NMAX = NCM(I)
      ENDDO
           
C
C Calculate the NAG-required workspace
C      
      NMAX1 = NMAX + 1
      LWORK = IP*N0 + NMAX1*(IP + 1)*(IP + 2)/2 + NMAX
C
C Check this as Simfit G11CAF requires more workspace
C
      NIMAX = N0
      NVMAX = IP
      NVMAX1 = NVMAX*(NVMAX + 1)/2
C ... Z starts in WK at I1
      I1 = 1
C ... COVI starts in WK at I2
      I2 = I1 + NIMAX*NVMAX
C ... CNTR starts in WK at I3
      I3 = I2 + NVMAX1
C ... W starts in WK at I4
      I4 = I3 + NXS*NVMAX
C ... WB starts in WK at I5
      I5 = I4 + NVMAX
C ... WDB starts in WK at I6
      I6 = I5 + NMAX1
C ... WDB2 starts in WK at I7
      I7 = I6 + NVMAX*NMAX1
C ... U starts in WK at I8
      I8 = I7 + NVMAX1*NMAX1
C ... DB starts in WK at I9
      I9 = I8 + NMAX
C ... D2B starts in WK at I10
      I10 = I9 + NVMAX
C
C Check that LWORK is large enough then allocate WORK
C
      IF (I10 + NVMAX1.GT.LWORK) LWORK = I10 + NVMAX1 
C
C Make sure LWORK is large enough then allocate
C
      LWORK = LWORK + 100
      IERR = 0
      ALLOCATE (WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 301
         GOTO 20
      ENDIF
C
C Interchange cases and controls
C
      DO I = 1, NUM
         IF (ID(I).EQ.0) THEN
            ID(I) = 1
         ELSE
            ID(I) = 0
         ENDIF
      ENDDO
C
C Call to G11CAF
C      
      IFAIL = -1
      CALL G11CAF$(NUM, IP, NXS, X, MXN, ISY, IP, ID, IXS, DEV, B, SE,
     +             SC, COV, NCA, NCT, TOL, MAXIT, IPRINT,
     +             WORK, LWORK, IFAIL)
      IF (IFAIL.NE.0) IFAIL = 400 + IFAIL
        
      
      IF (IFAIL.EQ.0) THEN
C
C Calculate RES and SUR
C        
         IF (LWORK.LT.2*ND) THEN
            DEALLOCATE(WORK, STAT = IERR)
            I = 2*ND
            ALLOCATE(WORK(I), STAT = IERR)
         ENDIF   
         CALL G12BAF$_AUX (ID, IP, IWK, ISI, ISZ, IXS, LDY, M, MXN,
     +                     NPTS, ND, NDMAX, NUM, NS,
     +                     B, WORK(1), WORK(ND + 1), WK, RES, SUR, T,
     +                     TP, X, Y)
       ENDIF 
C
C Deallocate
C 
   20 CONTINUE       
      DEALLOCATE(ICY, STAT = IERR)
      DEALLOCATE(ISIY, STAT = IERR)
      DEALLOCATE(ISY, STAT = IERR)
      DEALLOCATE(TY, STAT = IERR)
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(IXS, STAT = IERR)                     
      DEALLOCATE(ID, STAT = IERR)                     
      DEALLOCATE(NCA, STAT = IERR)                     
      DEALLOCATE(NCM, STAT = IERR)                     
      DEALLOCATE(NCT, STAT = IERR)                     
      DEALLOCATE(WORK, STAT = IERR)                     
      DEALLOCATE(X, STAT = IERR)                     
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE G12BAF$_AUX (ID, IP, IRS, ISI, ISZ, IXS, LDZ, M, MXN,
     +                        N, ND, NDMAX, NUM, NS,
     +                        B, DBOT, DTOP, H, RES, SUR, T, TP, X, Z)
      IMPLICIT NONE
C
C Arguments
C       
      INTEGER,          INTENT (IN)    :: IP, LDZ, M, MXN, N, ND, NDMAX,
     +                                    NUM, NS
      INTEGER,          INTENT (IN)    :: ID(MXN), IRS(N), ISI(N),
     +                                    ISZ(M), IXS(MXN)
      DOUBLE PRECISION, INTENT (IN)    :: B(IP), T(N), TP(ND), Z(LDZ,M)
      DOUBLE PRECISION, INTENT (INOUT) :: X(MXN,IP)
      DOUBLE PRECISION, INTENT (INOUT) :: DBOT(ND), DTOP(ND), H(ND), 
     +                                    RES(N), SUR(NDMAX,*) 
C
C Locals
C     
      INTEGER I, J, K, L, MSTRAT, NSTART, NSTOP
      DOUBLE PRECISION VP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00) 
      INTRINSIC  EXP

C
C Transform X(i,1) into the exponential of the inner products
C 
      DO I = 1, NUM
         VP = ZERO
         DO J = 1, IP
            VP = VP + X(I,J)*B(J)
         ENDDO
         X(I,1) = EXP(VP)  
      ENDDO  
      
      IF (NS.EQ.0) THEN
C
C ----------------------------------------------
C Only 1 stratum and points cannot be suppressed
C ----------------------------------------------
C
        
C
C Initialise
C      
         DO I = 1, ND
            DBOT(I) = ZERO
            DTOP(I) = ZERO
            H(I) = ZERO
         ENDDO
         DO L = 1, ND
            IF (L.EQ.1) THEN
               NSTART = 1
               NSTOP = IRS(1)
            ELSE
               NSTART = IRS(L - 1) + 1
               NSTOP = IRS(L)
            ENDIF
            DO I = NSTART, NSTOP
               IF (ID(I).EQ.0) DTOP(L) = DTOP(L) + ONE!ID has been reversed in G12BAF$
               DBOT(L) = DBOT(L) + X(I,1)  
            ENDDO  
         ENDDO
C
C Calculate H
C         
         NSTART = 1  
         DO L = 1, ND
            NSTOP = L
            DO I = NSTART, NSTOP
               IF (DBOT(I).GT.ZERO) H(L) = H(L) + DTOP(I)/DBOT(I)
            ENDDO  
            SUR(L,1) = EXP(-H(L))
         ENDDO  
C
C Calculate RES
C         
         DO I = 1, N
            L = ND 
            LOOP_J: DO J = 1, ND - 1
               IF (T(I).GE.TP(J) .AND. T(I).LT.TP(J + 1)) THEN
                  L = J
                  EXIT LOOP_J
               ENDIF
            ENDDO LOOP_J
            K = 0
            VP = ZERO
            DO J = 1, M
               IF (ISZ(J).GT.0) THEN
                  K = K + 1
                  VP = VP + Z(I,J)*B(K)
               ENDIF  
            ENDDO    
            RES(I) = H(L)*EXP(VP)  
         ENDDO
      ELSE
C
C --------------------------------------------------
C 1 or more strata but also points can be suppressed
C --------------------------------------------------
C        
         DO MSTRAT = 1, NS
C
C Initialise
C      
            DO I = 1, ND
               DBOT(I) = ZERO
               DTOP(I) = ZERO
               H(I) = ZERO
            ENDDO
            DO L = 1, ND
               IF (L.EQ.1) THEN
                  NSTART = 1
                  NSTOP = IRS(1)
               ELSE
                  NSTART = IRS(L - 1) + 1
                  NSTOP = IRS(L)
               ENDIF
               DO I = NSTART, NSTOP
                  IF (IXS(I).EQ.(MSTRAT - 1)*ND + L) THEN
                     IF (ID(I).EQ.0) DTOP(L) = DTOP(L) + ONE!ID has been reversed in G12BAF$
                     DBOT(L) = DBOT(L) + X(I,1)  
                  ENDIF   
               ENDDO 
            ENDDO
C
C Calculate H
C         
            NSTART = 1  
            DO L = 1, ND
               NSTOP = L
               DO I = NSTART, NSTOP
                  IF (DBOT(I).GT.ZERO) H(L) = H(L) + DTOP(I)/DBOT(I)
               ENDDO  
               SUR(L,MSTRAT) =  EXP(-H(L)) 
            ENDDO  
C
C Calculate RES
C         
            DO I = 1, N
               IF (ISI(I).EQ.MSTRAT) THEN
                  L = ND 
                  LOOP_K: DO J = 1, ND - 1
                     IF (T(I).GE.TP(J) .AND. T(I).LT.TP(J + 1)) THEN
                        L = J
                        EXIT LOOP_K
                     ENDIF
                  ENDDO LOOP_K
                  K = 0
                  VP = ZERO
                  DO J = 1, M
                     IF (ISZ(J).GT.0) THEN
                        K = K + 1
                        VP = VP + Z(I,J)*B(K)
                     ENDIF  
                  ENDDO    
                  RES(I) = H(L)*EXP(VP) 
               ENDIF   
            ENDDO  
         ENDDO
      ENDIF  
      END
C
C      
       