C
C
      SUBROUTINE G12ZAF$(N, M, NS, Z, LDZ, ISZ, IP, T, IC, ISI, NUM,
     +                   IXS, NXS, X, MXN, ID, ND, TP, IRS, IFAIL)
C
C ACTION: Version of G12ZAF 
C AUTHOR: w.g.bardsley, university of manchester, u.k., 05/08/2002
C         18/04/2013 expanded the loops to make it easier to understand so that it can be
C                    compressed more easily to use better sorting code when I find time                  
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER  LDZ, M, MXN, N
      INTEGER  NS, ISZ(M), IP, IC(N), ISI(*), NUM,
     +         IXS(MXN), NXS, ID(MXN), ND, IRS(N), IFAIL
      DOUBLE PRECISION Z(LDZ,M), T(N), X(MXN,IP), TP(N)
C
C Locals
C      
      INTEGER  I, IADD1, J, K, L
      DOUBLE PRECISION EPSI, T1, T1_MINUS, T1_PLUS, T2
      DOUBLE PRECISION SCALE1, TSMALL
      PARAMETER (SCALE1 = 1.0D-06, TSMALL = -1.0D-300)
      LOGICAL  ADDTOX
      EXTERNAL NXSORT
C
C Is it safe ?
C
      IFAIL = 0
      IF (M.LT.1 .OR. N.LT.2 .OR. NS.LT.0 .OR. LDZ.LT.N) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IADD1 = 0
      DO I = 1, M
         IF (ISZ(I).LT.0) THEN
            IFAIL = 2
            RETURN
         ENDIF
         IF (ISZ(I).GT.0) IADD1 = IADD1 + 1
      ENDDO
      IF (IP.NE.IADD1) THEN
         IFAIL = 2
         RETURN
      ENDIF
      DO I = 1, N
         IF (IC(I).LT.0 .OR. IC(I).GT.1) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO
      IF (NS.GT.0) THEN
         DO I = 1, N
            IF (ISI(I).LT.0) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ENDIF
      IF (NS.GT.1) THEN
         DO I = 1, N
            IF (ISI(I).GT.NS) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C Data supplied seems OK but MXN may be too small ... check later
C Start by forming TP and ND for the distinct FAILURE times
C
      IADD1 = 0
      IF (NS.EQ.0) THEN
         DO I = 1, N
            IF (IC(I).EQ.0) THEN
               IADD1 = IADD1 + 1
               TP(IADD1) = T(I)
            ENDIF
         ENDDO
      ELSE
        DO I = 1, N
           IF (ISI(I).GT.0) THEN
               IF (IC(I).EQ.0) THEN
                  IADD1 = IADD1 + 1
                  TP(IADD1) = T(I)
               ENDIF
            ENDIF   
         ENDDO
      ENDIF  
      CALL NXSORT (IADD1, TP)
      ND = 0
      T1 = TSMALL
      DO I = 1, IADD1
         T2 = TP(I)
         IF (T2.GT.T1) THEN
            ND = ND + 1
            TP(ND) = T2
            T1 = T2
         ENDIF
      ENDDO
C
C Now check that NUM =< MXN
C
      NUM = 0
C
C Loop to form the risk sets and calculate minimum NUM required
C
      IF (NS.EQ.0) THEN
         DO L = 1, ND
            T1 = TP(L)
            DO I = 1, N
               T2 = T(I)
               IF (T2.GE.T1) NUM = NUM + 1
            ENDDO      
         ENDDO
      ELSE
         DO L = 1, ND
            T1 = TP(L)
            DO I = 1, N
               IF (ISI(I).GT.0) THEN
                  T2 = T(I)
                  IF (T2.GE.T1) NUM = NUM + 1
               ENDIF     
            ENDDO      
         ENDDO

      ENDIF   
      IF (NUM.GT.MXN) THEN
         IFAIL = 3
         RETURN      
      ENDIF   
C
C Define EPSI to test for equality
C  
      EPSI = SCALE1*(TP(ND) - TP(1))    
C
C Initialise NUM then deal with the separate cases NS = 0, NS = 1, NS > 1
C
      NUM = 0
      IF (NS.EQ.0) THEN
C
C The case NS = 0: Loop to form the risk sets
C ================
C
         DO L = 1, ND
            T1 = TP(L)
            T1_MINUS = T1 - EPSI
            T1_PLUS = T1 + EPSI
            DO I = 1, N
               T2 = T(I)
               IF (T2.LT.T1_MINUS) THEN
C
C Dealt with previously
C

                  ADDTOX = .FALSE.
               ELSEIF (T2.GT.T1_PLUS) THEN
C
C Not yet failed or censored
C
                  NUM = NUM + 1
                  ADDTOX = .TRUE.
                  ID(NUM) = 0
               ELSE
C
C Failed or censored at this time
C
                  NUM = NUM + 1
                  ADDTOX = .TRUE.
                  IF (IC(I).EQ.0) THEN
                     ID(NUM) = 1
                  ELSE
                     ID(NUM) = 0
                  ENDIF
               ENDIF
               IF (ADDTOX) THEN
                  IXS(NUM) = L
                  K = 0
                  DO J = 1, M
                     IF (ISZ(J).GT.0) THEN
                        K = K + 1
                        X(NUM,K) = Z(I,J)
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IRS(L) = NUM
         ENDDO
      ELSEIF (NS.EQ.1) THEN
C
C The case NS = 1: Loop to form the risk sets
C ================
C
         DO L = 1, ND
            T1 = TP(L)
            T1_MINUS = T1 - EPSI
            T1_PLUS = T1 + EPSI
            DO I = 1, N
               T2 = T(I)
               IF (ISI(I).EQ.0) THEN
C
C Omit this point
C

                  ADDTOX = .FALSE.
               ELSEIF (T2.LT.T1_MINUS) THEN
C
C Dealt with previously
C

                  ADDTOX = .FALSE.
               ELSEIF (T2.GT.T1_PLUS) THEN
C
C Not yet failed or censored
C
                  NUM = NUM + 1
                  ADDTOX = .TRUE.
                  ID(NUM) = 0
               ELSE
C
C Failed or censored at this time
C
                  NUM = NUM + 1
                  IADD1 = IADD1 + 1
                  ADDTOX = .TRUE.
                  IF (IC(I).EQ.0) THEN
                     ID(NUM) = 1
                  ELSE
                     ID(NUM) = 0
                  ENDIF
               ENDIF
               IF (ADDTOX) THEN
                  IXS(NUM) = L
                  K = 0
                  DO J = 1, M
                     IF (ISZ(J).GT.0) THEN
                        K = K + 1
                        X(NUM,K) = Z(I,J)
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IRS(L) = NUM
         ENDDO
      ELSE
C
C The case NS > 1: Loop to form the risk sets
C ================
C
         DO L = 1, ND
            T1 = TP(L)
            T1_MINUS = T1 - EPSI
            T1_PLUS = T1 + EPSI
            DO I = 1, N 
               T2 = T(I)
               IF (ISI(I).EQ.0) THEN
C
C Omit this point
C

                  ADDTOX = .FALSE.
               ELSEIF (T2.LT.T1_MINUS) THEN
C
C Dealt with previously
C

                  ADDTOX = .FALSE.
               ELSEIF (T2.GT.T1_PLUS) THEN
C
C Not yet failed or censored
C
                  NUM = NUM + 1
                  ADDTOX = .TRUE.
                  ID(NUM) = 0
               ELSE
C
C Failed or censored at this time
C
                  NUM = NUM + 1
                  ADDTOX = .TRUE.
                  IF (IC(I).EQ.0) THEN
                     ID(NUM) = 1
                  ELSE
                     ID(NUM) = 0
                  ENDIF
               ENDIF
               IF (ADDTOX) THEN
                  J = ISI(I)
                  IXS(NUM) = (J - 1)*ND + L
                  K = 0
                  DO J = 1, M
                     IF (ISZ(J).GT.0) THEN
                        K = K + 1
                        X(NUM,K) = Z(I,J)
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IRS(L) = NUM
         ENDDO
      ENDIF
C
C Finally calculate NXS
C
      NXS = 0
      DO I = 1, NUM
         IF (IXS(I).GT.NXS) NXS = IXS(I)
      ENDDO
      END
c
c

















































