C
C
      SUBROUTINE G13AAF$(X, NX, ND, NDS, NS, XD, NXD, IFAIL)
C
C ACTION : Version of G13AAF
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 08/06/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL, ND, NDS, NS, NX, NXD
      INTEGER    I, J, K
      DOUBLE PRECISION X(NX), XD(NX)
C
C Test ND, NDS, NS and NX
C
      IFAIL = 0
      IF (ND.LT.0 .OR. NDS.LT.0 .OR. NS.LT.0 .OR.
     +   (NS.EQ.0 .AND. NDS.GT.0)) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (NX.LE.(ND + NDS*NS)) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Initialise NXD
C
      NXD = NX
C
C Copy X into XD
C
      DO I = 1, NX
         XD(I) = X(I)
      ENDDO
C
C Non-seasonal differencing if ND > 0
C
      IF (ND.GT.0) THEN
         DO I = 1, ND
            NXD = NXD - 1
            DO J = 1, NXD
               XD(J) = XD(J + 1) - XD(J)
            ENDDO
         ENDDO
      ENDIF
C
C Seasonal differencing if NDS > 0
C
      IF (NDS.GT.0) THEN
         DO I = 1, NDS
            NXD = NXD - NS
            DO J = 1, NXD
               K = J + NS
               XD(J) = XD(K) - XD(J)
            ENDDO
         ENDDO
      ENDIF
      END
C
C
