C
C
      SUBROUTINE G13ABF$(X, NX, NK, XM, XV, R, STAT, IFAIL)
C
C ACTION : Version of G13ABF
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/1/99
C
      IMPLICIT   NONE
      INTEGER    IFAIL, NX, NK
      INTEGER    I, K
      DOUBLE PRECISION R(NK), STAT, X(NX), XM, XV
      DOUBLE PRECISION DN, SSQ, XBAR
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      INTRINSIC  DBLE
C
C Test NX and NK
C
      IFAIL = 0
      IF (NX.LE.NK .OR. NX.LE.1 .OR. NK.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C Work out the mean
C
      DN = DBLE(NX)
      XBAR = ZERO
      DO I = 1, NX
         XBAR = XBAR + X(I)
      ENDDO
      XBAR = XBAR/DN
      XM = XBAR
C
C Work out the variance
C
      SSQ = ZERO
      DO I = 1, NX
         SSQ = SSQ + (X(I) - XBAR)**2
      ENDDO
      XV = SSQ/(DN - ONE)
C
C Test for all X equal
C
      IF (XV.LE.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Calculate R
C
      DO K = 1, NK
         R(K) = ZERO
         DO I = 1, NX - K
            R(K) = R(K) + (X(I) - XBAR)*(X(I + K) - XBAR)
         ENDDO
         R(K) = R(K)/SSQ
      ENDDO
C
C Calculate STAT
C
      STAT = ZERO
      DO I = 1, NK
         STAT = STAT + R(I)**2
      ENDDO
      STAT = DN*STAT
      END
C
C
