C
C
      SUBROUTINE G13ACF$(R, NK, NL, P, V, AR, NVL, IFAIL)
C
C ACTION : Version of G13ACF
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 08/06/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL, NK, NL, NVL
      INTEGER    I, J, K, KDIV2
      DOUBLE PRECISION AR(NL), P(NL), R(NK), V(NL)
      DOUBLE PRECISION DIFF, SUM1, TEMP
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      INTRINSIC  ABS
C
C Test NK, NL and R(1)
C
      IFAIL = 0
      IF (NK.LE.0 .OR. NL.LE.0 .OR. NK.LT.NL) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (ABS(R(1)).GE.ONE) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Initialise AR, P, V
C
      DO I = 1, NL
         AR(I) = ZERO
         P(I) = ZERO
         V(I) = ZERO
      ENDDO
C
C Start with NVL = 1
C
      NVL = 1
      AR(1) = R(1)
      P(1) = R(1)
      V(1) = (ONE - R(1))*(ONE + R(1))
C
C Exit if NL = 1
C
      IF (NL.EQ.1) RETURN
C
C The remaining NL - 1 cases
C
      DO K = 1, NL - 1
         SUM1 = ZERO
         DO I = 1, K
            J = K - I + 1
            SUM1 = SUM1 + AR(I)*R(J)
         ENDDO
         TEMP = (R(K + 1) - SUM1)/V(K)
         IF (ABS(TEMP).GE.ONE) THEN
C
C Exit with IFAIL = 3 if premature termination
C
            IFAIL = 3
            RETURN
         ENDIF
         NVL = NVL + 1
         AR(K + 1) = TEMP
         P(K + 1) = TEMP
         V(K + 1) = V(K)*(ONE - TEMP)*(ONE + TEMP)
         KDIV2 = K/2
         IF (KDIV2.EQ.0) THEN
            AR(KDIV2 + 1) = AR(KDIV2 + 1)*(ONE - TEMP)
         ELSE
            DO I = 1, KDIV2
               J = K - I + 1
               DIFF = AR(I) - TEMP*AR(J)
               AR(J) = AR(J) - TEMP*AR(I)
               AR(I) = DIFF
            ENDDO
            IF (K.NE.(2*KDIV2)) THEN
               AR(KDIV2 + 1) = AR(KDIV2 + 1)*(ONE - TEMP)
            ENDIF
         ENDIF
      ENDDO
      END
C
C
