c
c Auxiliary routines for G13
c ==========================
c
c adxg13
c adyg13
c adzg13
c aetg13
c aeug13
c aevg13
c aewg13
c aexg13
c aeyg13
c aezg13
c afzg13
c ahxg13
c ahyg13
c ahzg13
c
c

C
C G13 auxiliary routine
C
      SUBROUTINE ADXG13 (TOR, DELTA, ALPHA, IQ1, IFAIL1)
      IMPLICIT  NONE
      INTEGER   IFAIL1, IQ1
      INTEGER   I, INDA, J, N, NHALF
      DOUBLE PRECISION ALPHA(IQ1), DELTA(IQ1), TOR(IQ1)
      DOUBLE PRECISION ALPHAN
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      INTRINSIC  ABS
      IFAIL1 = 0
      IF (TOR(1).LE.ZERO) THEN
         IFAIL1 = 1
         RETURN
      ENDIF
      DO I = 1, IQ1
         ALPHA(I) = TOR(I)
      ENDDO
      IF (IQ1.GE.2) THEN
         DO I = 2, IQ1
            N = IQ1 - I + 2
            ALPHAN = ALPHA(N)/ALPHA(1)
            IF (ABS(ALPHAN).GE.ONE) THEN
               IFAIL1 = 1
               RETURN
            ENDIF
            ALPHA(1) = ALPHA(1) - ALPHAN*ALPHA(N)
            NHALF = (N + 1)/2
            IF (NHALF.GE.2) THEN
               INDA = N - 1
               DO J = 2, NHALF
                  ALPHA(N) = ALPHA(J)
                  ALPHA(J) = ALPHA(J) - ALPHAN*ALPHA(INDA)
                  IF (J.NE.INDA)
     +            ALPHA(INDA) = ALPHA(INDA) - ALPHAN*ALPHA(N)
                  INDA = INDA - 1
               ENDDO
            ENDIF
            ALPHA(N) = ALPHAN
            DELTA(N) = DELTA(N)/ALPHA(1)
            IF (N.NE.2) THEN
               NHALF = N - 1
               INDA = N - 1
               DO J = 2, NHALF
                  DELTA(J) = DELTA(J) - DELTA(N)*ALPHA(INDA)
                  INDA = INDA - 1
               ENDDO
            ENDIF
         ENDDO
      ENDIF
      DELTA(1) = DELTA(1)/(TWO*ALPHA(1))
      IF (IQ1.LT.2) RETURN
      DO I = 2, IQ1
         NHALF = (I + 1)/2
         INDA = I
         DO J = 1, NHALF
            ALPHAN = DELTA(J)
            DELTA(J) = DELTA(J) - ALPHA(I)*DELTA(INDA)
            IF (J.NE.INDA)
     +      DELTA(INDA) = DELTA(INDA) - ALPHA(I)*ALPHAN
            INDA = INDA - 1
         ENDDO
      ENDDO
      END
C
C

C
C Auxiliary routine for G13
C
      SUBROUTINE ADYG13 (COV, TOR, ERR, WA, IQ1, EPSILN, MAXITN, IFAIL1)
      IMPLICIT NONE
      INTEGER  IFAIL1, IQ1, MAXITN
      INTEGER  I, IQMI, ITERN, J, K
      DOUBLE PRECISION EPSILN
      DOUBLE PRECISION COV(IQ1), ERR(IQ1), TOR(IQ1), WA(IQ1)
      DOUBLE PRECISION EPS
      EXTERNAL  ADXG13
      INTRINSIC ABS, SQRT
      IFAIL1 = 0
      EPS = EPSILN*COV(1)
      ITERN = 0
      TOR(1) = SQRT(COV(1))
      DO I = 2, IQ1
         TOR(I) = COV(I)/COV(1)
      ENDDO
   20 CONTINUE
      DO I = 1, IQ1
         ERR(I) = COV(I)
         IQMI = IQ1 + 1 - I
         DO J = 1, IQMI
            K = J + I - 1
            ERR(I) = ERR(I) - TOR(J)*TOR(K)
         ENDDO
      ENDDO
      DO I = 1, IQ1
         IF (ABS(ERR(I)).GE.EPS) GOTO 40
      ENDDO
      GOTO 60
   40 CONTINUE
      IF (ITERN.GE.MAXITN) THEN
         IFAIL1 = 1
         RETURN
      ENDIF
      CALL ADXG13 (TOR, ERR, WA, IQ1, IFAIL1)
      IF (IFAIL1.NE.0) THEN
         IFAIL1 = 1
         RETURN
      ENDIF
      DO I = 1, IQ1
         TOR(I) = TOR(I) + ERR(I)
      ENDDO
      ITERN = ITERN + 1
      GOTO 20
   60 CONTINUE
      COV(1) = TOR(1)*TOR(1)
      DO I = 2, IQ1
         COV(I) = -TOR(I)/TOR(1)
      ENDDO
      END
C
C

C
C Auxiliary routine for G13
C
      SUBROUTINE ADZG13 (R, NL, MR, YV, PAR, NPAR, WA, NWA, RV, ISF)
      IMPLICIT NONE
      INTEGER  NL, NPAR, NWA
      INTEGER  ISF(4), MR(7)
      INTEGER  I, I1, I2, ID, IFAIL1, INDK, INDPAR, INDR,
     +         INDTP, ISEAS, ISP, ISQ, IWA, J1, J2, J3, JWA,
     +         KC, KWA, L1, L2, MAXITN
      DOUBLE PRECISION RV, YV
      DOUBLE PRECISION PAR(NPAR), R(NL), WA(NWA)
      DOUBLE PRECISION DET, EF, EPS, EPSILN, PG, SM
      DOUBLE PRECISION X02AJF$
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL  X02AJF$
      EXTERNAL  F03AFF$, F04AJF$, ADYG13, AEXG13
      INTRINSIC ABS, MAX
      DO I = 1, 4
         ISF(I) = 0
      ENDDO
      IF (MR(1).GT.0) ISF(1) = 1
      IF (MR(3).GT.0) ISF(2) = 1
      IF (MR(4).GT.0) ISF(3) = 1
      IF (MR(6).GT.0) ISF(4) = 1
      L1 = 0
      L2 = 0
      ISEAS = 1
      SM = X02AJF$()
      EF = 1000.0D+00
      EPS = EF*SM
      RV = YV
      DO I = 1, 2
         ISP = MR(3*I-2)
         ISQ = MR(3*I)
         IF (I.EQ.2) ISEAS = MR(7)
         IF (ISP.NE.0) THEN
            L1 = L2 + 1
            L2 = L1 + ISP - 1
            DO I1 = L1, L2
               PAR(I1) = ZERO
            ENDDO
            INDTP = 0
            DO I1 = 1, ISP
               DO I2 = 1, ISP
                  INDTP = INDTP + 1
                  INDR = (ISQ-I1+I2)*ISEAS
                  IF (INDR.EQ.0) THEN
                     GOTO 20
                  ELSE
                     GOTO 40
                  ENDIF
   20             CONTINUE
                  WA(INDTP) = ONE
                  GOTO 60
   40             CONTINUE
                  INDR = ABS(INDR)
                  WA(INDTP) = R(INDR)
   60             CONTINUE
               ENDDO
            ENDDO
            INDPAR = L1
            DO I1 = 1, ISP
               INDR = (ISQ+I1)*ISEAS
               PAR(INDPAR) = R(INDR)
               INDPAR = INDPAR + 1
            ENDDO
            IWA = INDTP + 1
            JWA = INDTP + ISP
            IFAIL1 = 1
            CALL F03AFF$(ISP, SM, WA(1), ISP, DET, ID, WA(IWA), IFAIL1)
            IF (IFAIL1.EQ.0) THEN
               CALL F04AJF$(ISP, 1, WA(1), ISP, WA(IWA), PAR(L1), ISP)
               INDPAR = L1
               DO I1 = IWA, JWA
                  WA(I1) = PAR(INDPAR)
                  INDPAR = INDPAR + 1
               ENDDO
               CALL AEXG13 (WA(IWA), ISP, EPS, PG, KC)
            ELSE
               KC = - 1
            ENDIF
            IF (KC.LT.0) THEN
               ISF(2*I-1) = -1
               DO I1 = L1, L2
                  PAR(I1) = ZERO
               ENDDO
            ENDIF
         ENDIF
         INDTP = ISQ + ISP + 1
         DO J1 = 1, INDTP
            INDK = J1 - 1
            IF (INDK.LE.ISQ) THEN
               GOTO 120
            ELSE
               GOTO 100
            ENDIF
  100       CONTINUE
            WA(J1) = ZERO
            GOTO 260
  120       CONTINUE
            IF (INDK.LE.0) THEN
               GOTO 140
            ELSE
               GOTO 160
            ENDIF
  140       CONTINUE
            WA(J1) = ONE
            GOTO 180
  160       CONTINUE
            INDK = INDK*ISEAS
            WA(J1) = R(INDK)
  180       CONTINUE
            IF (ISF(2*I-1).LE.0) GOTO 260
            INDPAR = L1
            DO J2 = 1, ISP
               INDR = INDK - (J2*ISEAS)
               IF (INDR.EQ.0) THEN
                  GOTO 200
               ELSE
                  GOTO 220
               ENDIF
  200          CONTINUE
               WA(J1) = WA(J1) - PAR(INDPAR)
               GOTO 240
  220          CONTINUE
               INDR = ABS(INDR)
               WA(J1) = WA(J1) - PAR(INDPAR)*R(INDR)
  240          CONTINUE
               INDPAR = INDPAR + 1
            ENDDO
  260       CONTINUE
         ENDDO
         INDTP = ISQ + 1
         IF (ISF(2*I-1).LE.0) GOTO 300
         DO J1 = 1, INDTP
            INDPAR = L1
            DO J2 = 1, ISP
               J3 = J1 + J2
               IF ((J3).GT.INDTP) GOTO 280
               WA(J1) = WA(J1) - PAR(INDPAR)*WA(J3)
               INDPAR = INDPAR + 1
            ENDDO
  280       CONTINUE
         ENDDO
  300    CONTINUE
         IF (ISQ.EQ.0) RV = RV*WA(1)
         IF (ISQ.EQ.0) GOTO 340
         L1 = L2 + 1
         L2 = L1 + ISQ - 1
         IWA = INDTP + 1
         JWA = IWA + INDTP
         KWA = JWA + INDTP
         EPSILN = MAX(100.0D+00*X02AJF$(),1.0D-7)
         MAXITN = 20
         CALL ADYG13 (WA(1), WA(IWA), WA(JWA), WA(KWA), INDTP, EPSILN,
     +                MAXITN, IFAIL1)
         RV = RV*WA(1)
         IF (IFAIL1.NE.0) GOTO 320
         INDPAR = L1
         DO J1 = 1, ISQ
            PAR(INDPAR) = WA(J1+1)
            INDPAR = INDPAR + 1
         ENDDO
         CALL AEXG13 (WA(2), ISQ, EPS, PG, KC)
         IF (KC.GT.0) GOTO 340
  320    CONTINUE
         ISF(2*I) = -1
         INDPAR = L1
         DO J1 = 1, ISQ
            PAR(INDPAR) = ZERO
            INDPAR = INDPAR + 1
         ENDDO
  340    CONTINUE
      ENDDO
      END
C
C

C
C Auxiliary routine for G13
C
      SUBROUTINE AETG13 (AEX, AAL, AEXR, NA, NP, ND, NQ, NPS, NDS, NQS,
     +                   NS, ST, NST)
      IMPLICIT NONE
      INTEGER  NA, ND, NDS, NP, NPS, NQ, NQS, NS, NST
      INTEGER  I, J, KA, KB, LQ, LST
      DOUBLE PRECISION AAL(NA), AEX(NA), AEXR(NA), ST(NST)
      LST = 0
      LQ = ND + NDS*NS
      KA = LQ + NPS*NS
      IF (KA.GT.0) THEN
         KB = NA - KA
         DO I = 1, KA
            J = KB + I
            LST = LST + 1
            ST(LST) = AEX(J)
         ENDDO
      ENDIF
      KA = NQS*NS
      IF (NP.GT.KA) KA = NP
      IF (KA.GT.0) THEN
         KB = NA - LQ - KA
         DO I = 1, KA
            J = KB + I
            LST = LST + 1
            ST(LST) = AAL(J)
         ENDDO
      ENDIF
      IF (NQ.GT.0) THEN
         KB = NA - LQ - NQ
         DO I = 1, NQ
            J = KB + I
            LST = LST + 1
            ST(LST) = AEXR(J)
         ENDDO
      ENDIF
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEUG13 (ID, EX, ALPHA, A, NA, W, BETA, B, NB, PHI,
     +                   THETA, SPHI, STHETA, NRMP, NP, NQ, NPS, NQS,
     +                   NS, NPD)
      IMPLICIT NONE
      INTEGER  ID, NA, NB, NP, NPD, NPS, NQ, NQS, NRMP, NS
      INTEGER  I, J, KA, KALPHA, KB, KBETA, KQ, KX
      DOUBLE PRECISION A(NA), ALPHA(NA), B(*), BETA(NB), EX(NA),
     +                 PHI(NRMP), SPHI(NRMP), STHETA(NRMP),
     +                 THETA(NRMP), W(NB)
      DOUBLE PRECISION ZERO
      DATA ZERO / 0.0D+00 /
      DO I = 1, NA
         ALPHA(I) = EX(I)
         IF (ID.EQ.5) GOTO 20
         IF (ID.EQ.6) GOTO 20
         IF (ID.EQ.4) GOTO 40
         IF (NPS.LE.0) GOTO 20
         DO J = 1, NPS
            KX = I - J*NS
            IF (KX.LE.0) GOTO 20
            ALPHA(I) = ALPHA(I) - SPHI(J)*EX(KX)
         ENDDO
   20    CONTINUE
         IF (NQS.LE.0) GOTO 40
         DO J = 1, NQS
            KALPHA = I - J*NS
            IF (KALPHA.LE.0) GOTO 40
            ALPHA(I) = ALPHA(I) + STHETA(J)*ALPHA(KALPHA)
         ENDDO
   40    CONTINUE
      ENDDO
      DO I = 1, NA
         A(I) = ALPHA(I)
         IF (ID.EQ.4) GOTO 60
         IF (ID.EQ.3) GOTO 60
         IF (ID.EQ.6) GOTO 80
         IF (NP.LE.0) GOTO 60
         DO J = 1, NP
            KALPHA = I - J
            IF (KALPHA.LE.0) GOTO 60
            A(I) = A(I) - PHI(J)*ALPHA(KALPHA)
         ENDDO
   60    CONTINUE
         IF (NQ.LE.0) GOTO 80
         DO J = 1, NQ
            KA = I - J
            IF (KA.LE.0) GOTO 80
            A(I) = A(I) + THETA(J)*A(KA)
         ENDDO
   80    CONTINUE
      ENDDO
      IF (ID.LE.0) RETURN
      IF (NPD.LE.0) RETURN
      KQ = NPS*NS
      DO I = 1, NPD
         IF (ID.EQ.7) GOTO 120
         IF (ID.LT.4) GOTO 120
         IF (ID.EQ.5) GOTO 100
         BETA(I) = W(I)
         IF (ID.EQ.6) THEN
            GOTO 180
         ELSE
            GOTO 200
         ENDIF
  100    CONTINUE
         BETA(I) = EX(I)
         GOTO 180
  120    CONTINUE
         KX = I - KQ
         IF (KX.GT.0) GOTO 140
         BETA(I) = ZERO
         GOTO 160
  140    CONTINUE
         BETA(I) = EX(KX)
  160    CONTINUE
         IF (NPS.LE.0) GOTO 180
         DO J = 1, NPS
            KX = I + J*NS - KQ
            IF (KX.GT.0)
     +      BETA(I) = BETA(I) - SPHI(J)*EX(KX)
         ENDDO
  180    CONTINUE
         IF (NQS.LE.0) GOTO 200
         DO J = 1, NQS
            KBETA = I - J*NS
            IF (KBETA.LE.0) GOTO 200
            BETA(I) = BETA(I) + STHETA(J)*BETA(KBETA)
         ENDDO
  200    CONTINUE
      ENDDO
      DO I = 1, NPD
         IF (ID.EQ.7) GOTO 220
         IF (ID.LT.3) GOTO 220
         IF (ID.EQ.5) GOTO 220
         B(I) = BETA(I)
         IF (ID.EQ.6) THEN
            GOTO 300
         ELSE
            GOTO 280
         ENDIF
  220    CONTINUE
         KBETA = I - NP
         IF (KBETA.GT.0) GOTO 240
         B(I) = ZERO
         GOTO 260
  240    CONTINUE
         B(I) = BETA(KBETA)
  260    CONTINUE
         IF (NP.LE.0) GOTO 280
         DO J = 1, NP
            KBETA = I + J - NP
            IF (KBETA.GT.0)
     +      B(I) = B(I) - PHI(J)*BETA(KBETA)
         ENDDO
  280    CONTINUE
         IF (NQ.LE.0) RETURN
         DO J = 1, NQ
            KB = I - J
            IF (KB.LE.0) RETURN
            B(I) = B(I) + THETA(J)*B(KB)
         ENDDO
  300    CONTINUE
      ENDDO
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEVG13 (NP, NQ, NPS, NQS, NS, AQ, NAQ, BQ, NBQ, KSCH,
     +                   AL, NA, NB, S, G, H, IZ, NGH)
      IMPLICIT NONE
      INTEGER  IZ, KSCH, NA, NAQ, NB, NBQ, NGH, NP, NPS, NQ,
     +         NQS, NS
      INTEGER  I, IH, IV, J, JH, JHL, JV, KHA, KHAQ, KHB, KHBQ,
     +         KHS, KVA, KVAQ, KVB, KVBQ, KVS, NAL, NGHP, NHL,
     +         NID, NPA, NPD, NQD, NVL
      INTEGER  MAK(7), MAL(7), MAS(7), MBK(7), MBL(7), MNC(7)
      DOUBLE PRECISION S
      DOUBLE PRECISION AL(NA), AQ(NAQ), BQ(NBQ), G(NGH), H(IZ,NGH)
      DOUBLE PRECISION ZERO
      DATA             MAK(1)/0/, MAK(2)/1/, MAK(3)/1/, MAK(4)/1/,
     +                 MAK(7)/0/
      DATA             MAL(1)/0/, MAL(2)/-1/, MAL(3)/0/, MAL(4)/0/,
     +                 MAL(5)/0/, MAL(6)/0/
      DATA             MBK(1)/0/, MBK(2)/1/, MBK(3)/-1/, MBK(4)/1/,
     +                 MBK(7)/0/
      DATA             MBL(1)/0/, MBL(2)/-1/, MBL(4)/0/, MBL(6)/0/,
     +                 MBL(7)/0/
      DATA             MAS(1)/1/, MAS(2)/-1/, MAS(3)/1/, MAS(4)/-1/,
     +                 MAS(5)/1/
      DATA             MAS(6)/-1/, MAS(7)/1/, MAL(7)/0/, MNC(1)/1/,
     +                 MNC(7)/1/
      DATA             ZERO / 0.0D+00 /
      DO J = 1, NGH
         G(J) = ZERO
         DO I = 1, IZ
            H(I,J) = ZERO
         ENDDO
      ENDDO
      NPD = NP + NPS*NS
      NQD = NQ + NQS*NS
      MAK(5) = NS
      MAK(6) = NS
      MBK(5) = -NS
      MBK(6) = NS
      MBL(3) = NP
      MBL(5) = NPS*NS
      MNC(2) = NQD
      MNC(3) = NP
      MNC(4) = NQ
      MNC(5) = NPS
      MNC(6) = NQS
      NID = KSCH
      IF (NID.GT.2) NID = NID + 3
      NPA = 0
      NGHP = NGH + 1
      DO IV = 1, NID
         IF (MNC(IV).LE.0) GOTO 180
         NVL = MNC(IV)
         KVS = MAS(IV)
         DO JV = 1, NVL
            KVA = MAK(IV)*JV + MAL(IV)
            KVB = MBK(IV)*JV + MBL(IV)
            DO I = 1, NGHP
               AL(I) = ZERO
            ENDDO
            NAL = NPA
            NPA = NPA + 1
            DO IH = IV, NID
               IF (MNC(IH).LE.0) GOTO 120
               NHL = MNC(IH)
               KHS = MAS(IH)
               JHL = JV
               IF (IH.NE.IV) JHL = 1
               DO JH = JHL, NHL
                  KHA = MAK(IH)*JH + MAL(IH)
                  KHB = MBK(IH)*JH + MBL(IH)
                  NAL = NAL + 1
                  DO I = 1, NA
                     KVAQ = I - KVA
                     IF (KVAQ.LE.0) GOTO 40
                     KVAQ = KVAQ + NA*(IV-1)
                     KHAQ = I - KHA
                     IF (KHAQ.LE.0) GOTO 40
                     KHAQ = KHAQ + NA*(IH-1)
                     IF (KVS.EQ.KHS) GOTO 20
                     AL(NAL) = AL(NAL) - AQ(KVAQ)*AQ(KHAQ)
                     GOTO 40
   20                CONTINUE
                     AL(NAL) = AL(NAL) + AQ(KVAQ)*AQ(KHAQ)
   40                CONTINUE
                  ENDDO
                  IF (NPD.LE.0) GOTO 100
                  DO I = 1, NPD
                     KVBQ = I - KVB
                     IF (KVBQ.LE.0) GOTO 80
                     KVBQ = KVBQ + NB*(IV-1)
                     KHBQ = I - KHB
                     IF (KHBQ.LE.0) GOTO 80
                     KHBQ = KHBQ + NB*(IH-1)
                     IF (KVS.EQ.KHS) GOTO 60
                     AL(NAL) = AL(NAL) + BQ(KVBQ)*BQ(KHBQ)
                     GOTO 80
   60                CONTINUE
                     AL(NAL) = AL(NAL) - BQ(KVBQ)*BQ(KHBQ)
   80                CONTINUE
                  ENDDO
  100             CONTINUE
               ENDDO
  120          CONTINUE
            ENDDO
            IF (IV.NE.1) GOTO 140
            S = AL(1)
            IF (KSCH.EQ.1) RETURN
            DO I = 2, NAL
               G(I-1) = AL(I)
            ENDDO
            GOTO 160
  140       CONTINUE
            DO I = NPA, NAL
               H(NPA-1,I-1) = AL(I)
            ENDDO
  160       CONTINUE
         ENDDO
  180    CONTINUE
      ENDDO
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEWG13 (EX, ALPHA, NA, BETA, NB, AQ, NAQ, BQ, NBQ,
     +                   KSCH, PHI, THETA, SPHI, STHETA, NRMP, NP, NQ,
     +                   NPS, NQS, NS, NPD, NQD)
      IMPLICIT NONE
      INTEGER  KSCH, NA, NAQ, NB, NBQ, NP, NPD, NPS, NQ, NQD,
     +         NQS, NRMP, NS
      INTEGER  I, J, K, NX
      DOUBLE PRECISION ALPHA(NA), AQ(NAQ), BETA(NB), BQ(NBQ), EX(NA),
     +                 PHI(NRMP), SPHI(NRMP), STHETA(NRMP), THETA(NRMP)
      DOUBLE PRECISION U, ZERO
      EXTERNAL         AEUG13
      DATA             ZERO / 0.0D+00 /, U / 1.0D+00 /
      DO I = 1, NAQ
         AQ(I) = ZERO
      ENDDO
      DO I = 1, NBQ
         BQ(I) = ZERO
      ENDDO
      CALL AEUG13 (1, EX, ALPHA, AQ(1), NA, BQ(1), BETA, BQ(1), NB, PHI,
     +             THETA, SPHI, STHETA, NRMP, NP, NQ, NPS, NQS, NS, NPD)
      IF (KSCH.EQ.1) RETURN
      IF (NQD.LE.0) GOTO 20
      AQ(2*NA + 1) = U
      CALL AEUG13 (2, AQ(2*NA + 1), ALPHA, AQ(NA + 1), NA, BQ(1), BETA,
     +             BQ(NB + 1),NB, PHI, THETA, SPHI, STHETA, NRMP, NP,
     +             NQ, NPS, NQS, NS, NPD)
      AQ(2*NA + 1) = ZERO
   20 CONTINUE
      IF (KSCH.EQ.2) RETURN
      IF (KSCH.EQ.3) GOTO 40
      K = NQD + 2*NA
      NX = NA - NQD
      DO I = 1, NX
         J = I + K
         AQ(J) = U
      ENDDO
      CALL AEUG13 (7, AQ(2*NA + 1), ALPHA, AQ(6*NA + 1), NA, BQ(1),
     +             BETA, BQ(6*NB + 1), NB, PHI, THETA, SPHI, STHETA,
     +             NRMP, NP, NQ, NPS, NQS, NS, NPD)
      K = 2*NA
      DO I = 1, NA
         J = I + K
         AQ(J) = ZERO
      ENDDO
   40 CONTINUE
      IF (NP.LE.0) GOTO 60
      CALL AEUG13 (3, EX, ALPHA, AQ(2*NA + 1), NA, BQ(1), BETA,
     +             BQ(2*NB + 1), NB, PHI, THETA, SPHI, STHETA, NRMP,
     +             NP, NQ, NPS, NQS, NS, NPD)
   60 CONTINUE
      IF (NQ.LE.0) GOTO 80
      CALL AEUG13 (4, AQ(1), ALPHA, AQ(3*NA + 1), NA, BQ(1), BETA,
     +             BQ(3*NB + 1), NB, PHI, THETA, SPHI, STHETA, NRMP,
     +             NP, NQ, NPS, NQS, NS, NPD)
   80 CONTINUE
      IF (NPS.LE.0) GOTO 100
      CALL AEUG13 (5, EX, ALPHA, AQ(4*NA + 1), NA, BQ(1), BETA,
     +             BQ(4*NB + 1), NB, PHI, THETA, SPHI, STHETA, NRMP,
     +             NP, NQ, NPS, NQS, NS, NPD)
  100 CONTINUE
      IF (NQS.LE.0) RETURN
      CALL AEUG13 (6, AQ(1), ALPHA, AQ(5*NA + 1), NA, BQ(1), BETA,
     +            BQ(5*NB + 1), NB, PHI, THETA, SPHI, STHETA, NRMP, NP,
     +            NQ, NPS, NQS, NS, NPD)
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEXG13 (ZB, NZB, EPS, PG, KC)
      IMPLICIT  NONE
      INTEGER   KC, NZB
      INTEGER   I, J, JH, K, KM, L
      DOUBLE PRECISION EPS, PG
      DOUBLE PRECISION ZB(NZB)
      DOUBLE PRECISION A, ETK, G, Q, RK, U, UME, UPE
      INTRINSIC ABS, DBLE
      DATA      U / 1.0D+00 /
      UPE = U + EPS
      UME = U - EPS
      PG = U
      KC = 1
      DO I = 1, NZB
         K = NZB - I + 1
         KM = K - 1
         A = ZB(K)
         IF (ABS(A).GT.UPE) GOTO 20
         IF (ABS(A).LT.UME) GOTO 40
         KC = 0
         IF (K.EQ.1) RETURN
         RK = DBLE(K)
         ETK = EPS*RK
         DO J = 1, KM
            L = K - J
            Q = ABS(ZB(J) + A*ZB(L))
            IF (Q.GE.ETK) GOTO 20
         ENDDO
         DO J = 1, KM
            ZB(J) = DBLE(K - J)*ZB(J)/RK
         ENDDO
         GOTO 80
   20    CONTINUE
         KC = -1
         RETURN
   40    CONTINUE
         G = (U - A)*(U + A)
         PG = PG*G
         IF (K.EQ.1) RETURN
         JH = KM/2
         IF (JH.LE.0) GOTO 60
         DO J = 1, JH
            L = K - J
            Q = ZB(J) + A*ZB(L)
            ZB(L) = (ZB(L) + A*ZB(J))/G
            ZB(J) = Q/G
         ENDDO
   60    CONTINUE
         IF (KM.EQ.(2*JH)) GOTO 80
         ZB(JH + 1) = ((U + A)*ZB(JH + 1))/G
   80    CONTINUE
      ENDDO
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEYG13 (MPQS, PA, IPA, KWPH, NPAR, WB, EF, MC, IERR)
      IMPLICIT NONE
      INTEGER  IERR, IPA, KWPH, NPAR
      INTEGER  MC(4), MPQS(4)
      INTEGER  I, J, K, KQ, NB
      DOUBLE PRECISION EF
      DOUBLE PRECISION PA(IPA), WB(NPAR)
      DOUBLE PRECISION PG
      EXTERNAL AEXG13
      IERR = 0
      DO I = 1, 4
         MC(I) = 0
         IF (MPQS(I).LE.0) GOTO 20
         NB = MPQS(I)
         KQ = KWPH + NPAR*(I-1) - 1
         DO J = 1, NB
            K = KQ + J
            WB(J) = PA(K)
         ENDDO
         CALL AEXG13 (WB, NB, EF, PG, MC(I))
         IF (MC(I).EQ.0 .AND. (I.EQ.1 .OR. I.EQ.3)) MC(I) = 1
         IF (MC(I).LE.0) IERR = 1
   20    CONTINUE
      ENDDO
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AEZG13 (PAR, NPAR, MPQS, WA, IWA, KWPH)
      IMPLICIT NONE
      INTEGER  IWA, KWPH, NPAR
      INTEGER  MPQS(4)
      INTEGER  I, J, K, L, LQ, N
      DOUBLE PRECISION PAR(NPAR), WA(IWA)
      K = 0
      DO I = 1, 4
         IF (MPQS(I).LE.0) GOTO 20
         N = MPQS(I)
         LQ = KWPH + NPAR*(I - 1) - 1
         DO J = 1, N
            K = K + 1
            L = LQ + J
            WA(L) = PAR(K)
         ENDDO
   20    CONTINUE
      ENDDO
      END
C
C




C
C Auxiliary routine for G13
C
      SUBROUTINE AHXG13 (AEX, NST, ND, NDS, NS, KDR, UV, DV)
      IMPLICIT NONE
      INTEGER  KDR, ND, NDS, NS, NST
      INTEGER  J, K
      DOUBLE PRECISION DV, UV
      DOUBLE PRECISION AEX(NST)
      DOUBLE PRECISION Q
      IF (KDR.NE.0) THEN
         UV = DV
         K = NST - ND - NDS*NS + 1
         IF (NDS.GT.0) THEN
            DO J = 1, NDS
               Q = UV + AEX(K)
               AEX(K) = UV
               UV = Q
               K = K + NS
            ENDDO
         ENDIF
         IF (ND.GT.0) THEN
            DO J = 1, ND
               Q = UV + AEX(K)
               AEX(K) = UV
               UV = Q
               K = K + 1
            ENDDO
         ENDIF
      ELSE
         DV = UV
         K = NST + 1
         IF (ND.GT.0) THEN
            DO J = 1, ND
               K = K - 1
               AEX(K) = DV - AEX(K)
               DV = AEX(K)
            ENDDO
         ENDIF
         IF (NDS.GT.0) THEN
            DO J = 1, NDS
               K = K - NS
               AEX(K) = DV - AEX(K)
               DV = AEX(K)
            ENDDO
         ENDIF
      ENDIF
      END
C
C


C
C Auxiliary routines for G13
C
      SUBROUTINE AHYG13 (ST, NST, NP, ND, NQ, NPS, NDS, NQS, NS, AEX,
     +                   AAL, AEXR)
      IMPLICIT NONE
      INTEGER  ND, NDS, NP, NPS, NQ, NQS, NS, NST
      INTEGER  I, J, JST, KA, KB, KC, KD
      DOUBLE PRECISION AAL(NST), AEX(NST), AEXR(NST), ST(NST)
      DOUBLE PRECISION ZERO
      DATA     ZERO / 0.0D+00 /
      DO I = 1, NST
         AEX(I) = ZERO
         AAL(I) = ZERO
         AEXR(I) = ZERO
      ENDDO
      KA = NPS*NS
      KB = ND + NDS*NS
      KC = NQS*NS
      IF (NP.GT.KC) KC = NP
      KD = NQ
      JST = 0
      IF (KA.GT.0) THEN
         DO I = 1, KA
            JST = JST + 1
            J = NST - KA - KB + I
            AEX(J) = ST(JST)
         ENDDO
      ENDIF
      IF (KB.GT.0) THEN
         DO I = 1, KB
            JST = JST + 1
            J = NST - KB + I
            AEX(J) = ST(JST)
         ENDDO
      ENDIF
      IF (KC.GT.0) THEN
         DO I = 1, KC
            JST = JST + 1
            J = NST - KB - KC + I
            AAL(J) = ST(JST)
         ENDDO
      ENDIF
      IF (KD.GT.0) THEN
         DO I = 1, KD
            JST = JST + 1
            J = NST - KB - KD + I
            AEXR(J) = ST(JST)
         ENDDO
      ENDIF
      END
C
C


C
C Auxiliary routine for G13
C
      SUBROUTINE AHZG13 (ST, NST, NP, ND, NQ, NPS, NDS, NQS, NS, PHI,
     +                   THETA, SPHI, STHETA, NPAR, C, RMS, NFV, FVA,
     +                   FSD, AEX, AAL, AEXR)
      IMPLICIT NONE
      INTEGER  ND, NDS, NFV, NP, NPAR, NPS, NQ, NQS, NS, NST
      INTEGER  I, J, K, KFA, LDS, NSTM, NT
      DOUBLE PRECISION C, RMS
      DOUBLE PRECISION AAL(NST), AEX(NST), AEXR(NST), FSD(NFV),
     +                 FVA(NFV), PHI(NPAR), SPHI(NPAR), ST(NST),
     +                 STHETA(NPAR), THETA(NPAR)
      DOUBLE PRECISION A, AL, D, U, UX, X, ZERO
      EXTERNAL  AHXG13, AHYG13
      INTRINSIC SQRT
      DATA ZERO / 0.0D+00 /, U / 1.0D+00 /
      CALL AHYG13 (ST, NST, NP, ND, NQ, NPS, NDS, NQS, NS, AEX, AAL,
     +             AEXR)
      LDS = NST - ND - NDS*NS
      NT = LDS + 1
      NSTM = NST - 1
      D = C
      A = ZERO
      KFA = 0
   20 CONTINUE
      DO I = 1, NFV
         AL = A
         IF (NP.GT.0) THEN
            DO J = 1, NP
               K = NT - J
               AL = AL + PHI(J)*AAL(K)
            ENDDO
         ENDIF
         IF (NQ.GT.0) THEN
               DO J = 1, NQ
               K = NT - J
               AL = AL - THETA(J)*AEXR(K)
            ENDDO
         ENDIF
         X = AL + C
         IF (NPS.GT.0) THEN
            DO J = 1, NPS
               K = NT - J*NS
               X = X + SPHI(J)*(AEX(K) - C)
            ENDDO
         ENDIF
         IF (NQS.GT.0) THEN
            DO J = 1, NQS
               K = NT - J*NS
               X = X - STHETA(J)*AAL(K)
            ENDDO
         ENDIF
         CALL AHXG13 (AEX, NST, ND, NDS, NS, 1, UX, X)
         IF (KFA.EQ.0) THEN
            FVA(I) = UX
         ELSE
            FSD(I) = UX
         ENDIF
         IF (I.NE.NFV) THEN
            IF (NSTM.GT.0) THEN
               DO J = 1, NSTM
                  AEX(J) = AEX(J + 1)
                  AAL(J) = AAL(J + 1)
                  AEXR(J) = AEXR(J + 1)
               ENDDO
            ENDIF
            AEX(NST) = UX
            AAL(LDS) = AL
            AEXR(LDS) = A
            A = ZERO
         ENDIF
      ENDDO
      IF (KFA.NE.1) THEN
         A = U
         KFA = 1
         C = ZERO
         DO J = 1, NST
            AEX(J) = ZERO
            AAL(J) = ZERO
            AEXR(J) = ZERO
         ENDDO
         GOTO 20
      ELSE
         C = D
         D = ZERO
         DO I = 1, NFV
            D = D + FSD(I)**2
            FSD(I) = SQRT(RMS*D)
         ENDDO
      ENDIF
      END
C
C
