C
C
      DOUBLE PRECISION FUNCTION S01BAF$(XX, IFAIL)
C
C ACTION : log(1 + x) using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 28/12/2001
C          Equivalent to IFAIL = 1 soft fail, no error trapping
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      DOUBLE PRECISION X
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION DLNREL
      EXTERNAL   DLNREL
C
C Copy XX into X so XX is returned unchanged
C
      X = XX
      IF (X.LE.- ONE) THEN
C
C Failure if X =< -1
C

         S01BAF$ = ZERO
         IFAIL = 1
      ELSE
C
C DLNREL
C
         IFAIL = 0
         S01BAF$ = DLNREL(X)
      ENDIF
      END
C
C
