C
C
      DOUBLE PRECISION FUNCTION S13AAF$(X, IFAIL)
C
C ACTION: Exponential integral E1 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, ZERO
      PARAMETER (XBIG = 650.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION DE1
      EXTERNAL   DE1
      IF (X.LE.ZERO) THEN
         S13AAF$ = ZERO
         IFAIL = 1
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 0
         S13AAF$ = ZERO
      ELSE
         IFAIL = 0
         S13AAF$ = DE1(X)
      ENDIF
      END
C
C
