C
C
      DOUBLE PRECISION FUNCTION S13ACF$(X, IFAIL)
C
C ACTION: Cosine integral ci(x) using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 18/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, ZERO
      PARAMETER (XBIG = 1.0D+16, ZERO = 0.0D+00)
      DOUBLE PRECISION DCI
      EXTERNAL   DCI
      IF (X.LE.ZERO) THEN
         IFAIL = 1
         S13ACF$ = ZERO
      ELSEIF (X.GE.XBIG) THEN
         IFAIL = 0
         S13ACF$ = ZERO
      ELSE
         IFAIL = 0
         S13ACF$ = DCI(X)
      ENDIF
      END
C
C
