C
C
      DOUBLE PRECISION FUNCTION S14AAF$(XX, IFAIL)
C
C ACTION : Returns the gamma function using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION XX
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION DGAMMA, X, Y
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EPSI, RTOL, XBIG
      PARAMETER (EPSI = 1.0D-18, RTOL = 1.0D-300, XBIG = 170.0D+00)
      EXTERNAL   DGAMMA
      INTRINSIC  ABS, DBLE, INT, MAX, MIN
C
C Initialise
C
      X = XX
      S14AAF$ = ZERO
      IFAIL = 0
C
C Check for large and small X
C
      IF (X.GT.XBIG) THEN
         X = XBIG
         IFAIL = 1
      ELSEIF (X.LT.-XBIG) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Check for close to zero
C
      IF (ABS(X).LE.EPSI) THEN
         IF (X.LT.ZERO) THEN
            X = MIN(X, -RTOL)
         ELSE
            X = MAX(X, RTOL)
         ENDIF
         S14AAF$ = ONE/X
         IFAIL = 3
         RETURN
      ENDIF
C
C Check for negative integer
C
      IF (X.LT.ZERO) THEN
         I = INT(X)
         Y = X - DBLE(I)
         IF (ABS(Y).LE.EPSI) THEN
            X = XBIG
            IFAIL = 4
         ENDIF
      ENDIF
      S14AAF$ = DGAMMA(X)
      END
C
C
