C
C
      DOUBLE PRECISION FUNCTION S14ACF$(X, IFAIL)
C
C ACTION : Returns the (psi - log x) function using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
C
C Local variables
C
      INTEGER    KODE, M, N, NZ
      PARAMETER (KODE = 2, M = 2, N = 0)
      DOUBLE PRECISION ANS(M)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION RTOL, XBIG, XSMALL
      PARAMETER (RTOL = 1.0D-300, XBIG = 1.0D+150, XSMALL = 1.0D-150)
      EXTERNAL   DPSIFN
C
C Initialise
C
      S14ACF$ = ZERO
      IFAIL = 0
C
C Check for large and small X
C
      IF (X.LE.ZERO) THEN
         IFAIL = 1
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 2
      ELSEIF (X.LT.XSMALL .AND. X.GE.RTOL) THEN
         S14ACF$ = -ONE/X
      ELSEIF (X.LT.RTOL) THEN
         IFAIL = 3
      ELSE
         CALL DPSIFN (X, N, KODE, M, ANS, NZ, IFAIL)
         S14ACF$ = - ANS(1)
      ENDIF
      END
C
C
