C
C
      SUBROUTINE S14ADF$(X, N, M, ANS, IFAIL)
C
C ACTION : Returns d/dx(psi(x)) functions using SLATEC
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 14/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL, M, N
      DOUBLE PRECISION X, ANS(M)
C
C Local variables
C
      INTEGER    I, KODE, NZ
      PARAMETER (KODE = 1)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION XBIG, XSMALL
      PARAMETER (XBIG = 1.0D+76, XSMALL = 1.0D-77)
      EXTERNAL   DPSIFN
C
C Initialise
C
      IFAIL = 0
      DO I = 1, M
         ANS(I) = ZERO
      ENDDO
C
C Check for large and small X, N, M
C
      IF (X.LE.ZERO) THEN
         IFAIL = 1
      ELSEIF (N.LT.0) THEN
         IFAIL = 2
      ELSEIF (M.LT.1) THEN
         IFAIL = 3
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 4
      ELSEIF (X.LT.XSMALL) THEN
         IFAIL = 5
      ELSE
         CALL DPSIFN (X, N, KODE, M, ANS, NZ, IFAIL)
      ENDIF
      END
C
C
