C
C
      SUBROUTINE S14BAF$(A, X, TOL, P, Q, IFAIL)
C
C ACTION : Incomplete gamma function after Abramovitch and Stegun
C          using the series or continued fraction depending on
C          the values of X and A
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/3/97
C          28/02/2002 edited
C
      IMPLICIT NONE
      INTEGER  IFAIL
      DOUBLE PRECISION A, X, TOL, P, Q
C
C Local variables
C
      INTEGER    NMAX
      PARAMETER (NMAX = 100)
      INTEGER    I
      DOUBLE PRECISION ZERO, RTOL, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, RTOL = 1.0D-300, EPSI = 1.0D-06,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION ADD1, ARG, A1, CHECK, GAMLOG, TERM, TOL1, SUM1,
     +                 X1
      DOUBLE PRECISION A00, A11, B00, B11, CF1, CF2, DI, DIMA1, DITF,
     +                 FACTOR
      DOUBLE PRECISION S14ABF$
      EXTERNAL S14ABF$
      INTRINSIC ABS, DBLE, EXP, LOG
C
C Check arguments supplied
C
      IFAIL = 0
      P = ZERO
      Q = ZERO
      IF (A.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ELSEIF (X.LT.ZERO) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Make copies of the arguments supplied
C
      IF (TOL.LT.EPSI) THEN
         TOL1 = EPSI
      ELSE
         TOL1 = TOL
      ENDIF
      IF (A.LE.RTOL) THEN
         A1 = RTOL
      ELSE
         A1 = A
      ENDIF
      IF (X.LE.RTOL) THEN
          X1 = RTOL
      ELSE
          X1 = X
      ENDIF
C
C The method to be used depends on whether x > a + 1 but first log(gamma)
C
      I = 1
      GAMLOG = S14ABF$(A1, I)
      IF (X1.LT.A1 + ONE) THEN
C
C Use the series exploiting the recursive gamma function identity
C
         ADD1 = A1
         SUM1 = ONE/ADD1
         TERM = SUM1
         DO I = 1, NMAX
            ADD1 = ADD1 + ONE
            TERM = TERM*X1/ADD1
            SUM1 = SUM1 + TERM
            CHECK = TOL1*SUM1
            IF (TERM.LE.CHECK) GOTO 20
         ENDDO
   20    CONTINUE
         ARG = X1 - A1*LOG(X1) + GAMLOG
         P = SUM1*EXP(- ARG)
         Q = ONE - P
      ELSE
C
C Use the continued fraction normalising after each cycle
C
         CF1 = ZERO
         A00 = ONE
         A11 = X1
         B00 = ZERO
         B11 = ONE
         FACTOR = ONE
         DO I = 1, NMAX
            DI = DBLE(I)
            DIMA1 = DI - A1
            A00 = (A11 + A00*DIMA1)*FACTOR
            B00 = (B11 + B00*DIMA1)*FACTOR
            DITF = DI*FACTOR
            A11 = X1*A00 + DITF*A11
            B11 = X1*B00 + DITF*B11
            IF (ABS(A11).GT.RTOL) THEN
               FACTOR = ONE/A11
               CF2 = B11*FACTOR
               IF (ABS(CF2).GT.RTOL) THEN
                  CHECK = ABS(ONE - CF1/CF2)
                  IF (CHECK.LE.TOL1) GOTO 40
               ENDIF
               CF1 = CF2
            ENDIF
         ENDDO
   40    CONTINUE
         ARG = X1 - A1*LOG(X1) + GAMLOG
         Q =  EXP(-ARG)*CF2
         P = ONE - Q
      ENDIF
      END
C
C
