C
C
      DOUBLE PRECISION FUNCTION S17ACF$(X, IFAIL)
C
C ACTION: Bessel function Y0 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION FACTOR, XBIG, ZERO
      PARAMETER (FACTOR = 0.7978845D+00, XBIG = 4.0D+15, ZERO = 0.0D+00)
      DOUBLE PRECISION DBESY0
      EXTERNAL   DBESY0
      INTRINSIC  SQRT
      IF (X.LE.ZERO) THEN
         S17ACF$ = ZERO
         IFAIL = 2
         RETURN
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 1
         S17ACF$ = FACTOR/SQRT(X)
      ELSE
         IFAIL = 0
         S17ACF$ = DBESY0(X)
      ENDIF
      END
C
C
