C
C
      DOUBLE PRECISION FUNCTION S17ADF$(X, IFAIL)
C
C ACTION: Bessel function Y1 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION FACTOR, XBIG, ZERO
      PARAMETER (FACTOR = 0.7978845D+00, XBIG = 4.0D+15, ZERO = 0.0D+00)
      DOUBLE PRECISION XMAX, XMIN, XTEMP
      PARAMETER (XMAX = 1.D+300, XMIN = 1.0D+00/XMAX)
      DOUBLE PRECISION DBESY1
      EXTERNAL   DBESY1
      INTRINSIC  SQRT
      IF (X.LE.ZERO) THEN
         S17ADF$ = ZERO
         IFAIL = 2
         RETURN
      ELSEIF (X.GT.XBIG) THEN
         XTEMP = X
         IF (XTEMP.GT.XMAX) XTEMP = XMAX
         IFAIL = 1
         S17ADF$ = FACTOR/SQRT(XTEMP)
      ELSE
         XTEMP = X
         IF (XTEMP.LT.XMIN) THEN
            XTEMP = XMIN
            IFAIL = 1
         ELSE
            IFAIL = 0
         ENDIF
         S17ADF$ = DBESY1(XTEMP)
      ENDIF
      END
C
C
