C
C
      DOUBLE PRECISION FUNCTION S17AEF$(X, IFAIL)
C
C ACTION: Bessel function J0 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION FACTOR, XBIG, XSMALL, ONE
      PARAMETER (FACTOR = 0.7978845D+00, XBIG = 4.0D+15,
     +           XSMALL = 1.0D-10, ONE = 1.0D+00)
      DOUBLE PRECISION DBESJ0
      EXTERNAL   DBESJ0
      INTRINSIC  ABS, SQRT
      IF (X.GT.XBIG) THEN
         IFAIL = 1
         S17AEF$ = FACTOR/SQRT(X)
      ELSEIF (ABS(X).LT.XSMALL) THEN
         IFAIL = 0
         S17AEF$ = ONE
      ELSE
         IFAIL = 0
         S17AEF$ = DBESJ0(X)
      ENDIF
      END
C
C
