C
C
      DOUBLE PRECISION FUNCTION S17AFF$(X, IFAIL)
C
C ACTION: Bessel function J1 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION FACTOR, XBIG, XSMALL, TWO
      PARAMETER (FACTOR = 0.7978845D+00, XBIG = 4.0D+15,
     +           XSMALL = 1.0D-10, TWO = 2.0D+00)
      DOUBLE PRECISION DBESJ1
      EXTERNAL   DBESJ1
      INTRINSIC  ABS, SQRT
      IF (ABS(X).LT.XSMALL) THEN
         S17AFF$ = X/TWO
         IFAIL = 0
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 1
         S17AFF$ = FACTOR/SQRT(X)
      ELSE
         IFAIL = 0
         S17AFF$ = DBESJ1(X)
      ENDIF
      END
C
C
