C
C
      DOUBLE PRECISION FUNCTION S17AGF$(X, IFAIL)
C
C ACTION: Airy function Ai using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, XSMALL, ZERO
      PARAMETER (XBIG = 90.0D+00, XSMALL = -1.0D+10, ZERO = 0.0D+00)
      DOUBLE PRECISION DAI
      EXTERNAL   DAI
      IF (X.LT.XSMALL) THEN
         S17AGF$ = ZERO
         IFAIL = 2
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 1
         S17AGF$ = ZERO
      ELSE
         IFAIL = 0
         S17AGF$ = DAI(X)
      ENDIF
      END
C
C
