C
C
      DOUBLE PRECISION FUNCTION S17AHF$(X, IFAIL)
C
C ACTION: Airy function Bi using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, XSMALL, ZERO
      PARAMETER (XBIG = 90.0D+00, XSMALL = -1.0D+10, ZERO = 0.0D+00)
      DOUBLE PRECISION DBI
      EXTERNAL   DBI
      IF (X.LT.XSMALL) THEN
         S17AHF$ = ZERO
         IFAIL = 2
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 1
         S17AHF$ = ZERO
      ELSE
         IFAIL = 0
         S17AHF$ = DBI(X)
      ENDIF
      END
C
C
