C
C
      DOUBLE PRECISION FUNCTION S17AJF$(X, IFAIL)
C
C ACTION: Airy function derivative DAi using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, XSMALL, ZERO
      PARAMETER (XBIG = 90.0D+00, XSMALL = -1.0D+10, ZERO = 0.0D+00)
      DOUBLE PRECISION AI, DAI, RC, C
      EXTERNAL   DJAIRY
      INTRINSIC  ABS, SQRT
      IF (X.LT.XSMALL) THEN
         S17AJF$ = ZERO
         IFAIL = 2
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 1
         S17AJF$ = ZERO
      ELSE
         IFAIL = 0
         RC = SQRT(ABS(X))
         C = 2.0D+00*(ABS(X)**1.5D+00)/3.0D+00
         CALL DJAIRY (X, RC, C, AI, DAI)
         S17AJF$ = DAI
      ENDIF
      END
C
C
