C
C
      DOUBLE PRECISION FUNCTION S18ACF$(X, IFAIL)
C
C ACTION: Bessel function K0 using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION XBIG, ZERO
      PARAMETER (XBIG = 650.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION DBESK0
      EXTERNAL   DBESK0
      IF (X.LE.ZERO) THEN
         S18ACF$ = ZERO
         IFAIL = 1
         RETURN
      ELSEIF (X.GT.XBIG) THEN
         IFAIL = 0
         S18ACF$ = ZERO
      ELSE
         IFAIL = 0
         S18ACF$ = DBESK0(X)
      ENDIF
      END
C
C
