C
C
      DOUBLE PRECISION FUNCTION S19AAF$(X,IFAIL)
C
C ACTION: Version of S19AAF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 19/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION A, B, C, D, E, F, G, H, P, Q, T, T2, U, V, Y, Z
      DOUBLE PRECISION ABSX
      DOUBLE PRECISION ZERO, ONE, TWO, FIVE, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FIVE = 5.0D+00, TEN = 10.0D+00)
C
C Limits for x
C
      DOUBLE PRECISION XMAX, XMIN
      PARAMETER (XMAX = 49.5D+00, XMIN = 0.082D+00)
C
C 1/root(2), 1/root(pi), pi/8
C
      DOUBLE PRECISION CRT2, CRTPI, PIBY8
      PARAMETER (CRT2 = 0.707106781D+00, CRTPI = 0.564189584D+00,
     +           PIBY8 = 0.392699082D+00)
      INTRINSIC  ABS, COS, EXP, SIN, SQRT
      ABSX = ABS(X)
      IF (ABSX.GE.XMAX) THEN
C
C Error exit if x too large
C
         IFAIL = 1
         S19AAF$ = ZERO
      ELSEIF (ABSX.LE.XMIN) THEN
C
C Default exit if x too small
C
         IFAIL = 0
         S19AAF$ = ONE
      ELSEIF (ABSX.LE.FIVE) THEN
C
C The case |x| < 5
C
         IFAIL = 0
         T = ABSX/FIVE
         T = T*T
         T = TWO*T*T - ONE
         T2 = TWO*T
         A = -1.33992330D-08
         B = T2*A + 1.10545452D-05
         C = T2*B - A - 3.50415931D-03
         A = T2*C - B + 3.09890198D-01
         B = T2*A - C - 3.61153707D+00
         Y = T*B - A - 2.92494249D+00
         S19AAF$ = Y
      ELSE
C
C The case |x| > 5
C
         IFAIL = 0
         T = ABSX*CRT2
         Y  = EXP(T)
         Z = EXP(-T)
         P = T - PIBY8
         Q = PIBY8 + T
         T = ONE/ABSX
         T2 = (T/CRT2)/CRTPI
         D = (T/CRT2)*CRTPI
         T = TEN*T - ONE
         E = (((((((((
     +          -1.69376790D-8*T + 8.50832086D-8)*T + 8.40122556D-8)
     +       *T-7.04305506D-7)*T - 4.12348456D-7)*T + 5.21850058D-6)
     +       *T+8.21050182D-6)*T - 5.18019764D-5)*T - 3.66273903D-4)
     +       *T-5.68197115D-4)*T + 3.50048578D-2
         F = (((((((((
     +          +3.68130492D-8*T + 2.55352856D-8)*T - 2.95020203D-7)
     +       *T-1.45996162D-7)*T + 1.88644303D-6)*T + 1.56703721D-6)
     +       *T-1.59649361D-5)*T - 5.08763679D-5)*T + 1.41592439D-4)
     +       *T+3.17930146D-3)*T + 3.82644649D-2
         G = (((((((
     +          -1.94926826D-8*T + 2.95850031D-8)*T + 1.58980882D-7)
     +       *T-1.70466555D-6)*T + 1.22048411D-5)*T - 7.38533627D-5)
     +       *T+3.36077066D-4)*T + 9.51645008D-4)*T - 1.10250670D-1
         H = (((((((
     +          +1.93398892D-8*T - 1.04909350D-7)*T + 4.19363620D-7)
     +       *T-1.40226295D-6)*T + 1.76673277D-6)*T + 3.42555009D-5)
     +       *T-5.79989486D-4)*T + 7.56710357D-3)*T - 1.02600730D-1
         T = (CRT2/SQRT(ABSX))*CRTPI
         U = (T2*E + ONE)*COS(P) + (T2*F)*SIN(P)
         V = (D*G + ONE)*SIN(Q) + (D*H)*COS(Q)
         S19AAF$ = (Y*U + Z*V)*T
      ENDIF
      END
C
C
