C
C
      DOUBLE PRECISION FUNCTION S19ADF$(X, IFAIL)
C
C ACTION: version of S19ADF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 19/12/2001
C
      IMPLICIT NONE
      INTEGER  IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION A, B, E, F, G, H, Q, T, T2, V, Y, Z
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, SIX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION HALF, QUART
      PARAMETER (HALF = 0.5D+00, QUART = 0.25D+00)
      DOUBLE PRECISION XMAX, XMIN, XSMALL
      PARAMETER (XMAX = 998.0D+00, XMIN = 5.0D-20,
     +           XSMALL = 0.05D+00)
      DOUBLE PRECISION CRT2, EGAM, ALOGX, PIB4, RT2BPI
      PARAMETER (CRT2 = 0.707106781D+00,
     +           EGAM = 0.577215665D+00,
     +           ALOGX = 0.693147181D+00,
     +           PIB4 = 0.785398163D+00,
     +           RT2BPI = 0.797884561D+00)
      INTRINSIC LOG, COS, EXP, SIN, SQRT
      IF (X.GE.XMAX) THEN
C
C Error exit: x too large
C
         IFAIL = 1
         S19ADF$ = ZERO
      ELSEIF (X.LT.ZERO) THEN
C
C Error exit: x too small
C
         IFAIL = 2
         S19ADF$ = ZERO
      ELSEIF (X.LE.XMIN) THEN
C
C x very small
C
         IFAIL = 0
         S19ADF$ = -PIB4
      ELSEIF (X.LE.XSMALL) THEN
C
C x small
C
         IFAIL = 0
         E = QUART*X*X
         Q = ONE + ALOGX - EGAM - LOG(X)
         S19ADF$ = -PIB4 + E*Q
      ELSEIF (X.LE.ONE) THEN
C
C x < 1
C
         IFAIL = 0
         T = X*X
         E = QUART*T
         T = TWO*T*T - ONE
         T2 = TWO*T
         A = +8.47622202D-07
         B = T2*A - 7.80910938D-03
         Y = T*B - A + 9.92190043D-01
         A = +3.39066181D-8
         B = T2*A - 8.67919926D-04
         F = T*B - A + 9.99132046D-01
         A = +8.13503991D-08
         B = T2*A - 1.69174477D-03
         H = T*B - A + 1.11423969D+00
         S19ADF$ = (-LOG(X)*F + H)*E - PIB4*Y
      ELSEIF (X.LE.THREE) THEN
C
C x < 3
C
         IFAIL = 0
         T = X - TWO
         Y = (((((((((
     +           + 2.06282021D-6*T - 4.72186095D-6)*T + 1.12843802D-5)
     +       *T - 1.75383165D-5)*T - 2.71419482D-4)*T - 3.03720774D-3)
     +       *T - 7.11234206D-4)*T + 9.32834532D-2)*T + 4.11942050D-1)
     +       *T - 7.48787980D-2)*T - 1.92031838D+0
         S19ADF$ = EXP(-1.125D+00*X)*Y
      ELSE
         IFAIL = 0
         T = X*CRT2
         Z = EXP(-T)
         Q = HALF*PIB4 + T
         T = ONE/X
         V = T*RT2BPI
         T = SIX*T - ONE
         G = (((((((((
     +            -6.80882401D-8*T + 1.28382703D-7)*T + 1.42911408D-8)
     +       *T - 5.01412819D-7)*T + 2.85165297D-6)*T - 1.38346253D-5)
     +       *T + 5.87689013D-5)*T - 2.21708182D-4)*T + 6.01027710D-4)
     +       *T + 2.19032188D-3)*T - 1.09486554D-1
         H = ((((((((
     +           - 1.39989253D-7*T + 4.91589405D-7)*T - 1.16706419D-6)
     +       *T + 2.87461558D-6)*T - 5.09025971D-6)*T - 7.14778789D-6)
     +       *T + 1.60368594D-4)*T - 1.41645294D-3)*T + 1.14007384D-2)
     +       *T - 9.78034215D-2
         T = SQRT((PIB4/X)*TWO)
         V = (V*G + ONE)*SIN(Q) + (V*H)*COS(Q)
         S19ADF$ = -Z*V*T
      ENDIF
      END
C
C
