C
C Includes code ACMTOMS 723 for Fresnel integrals
C ===============================================
C
C
      DOUBLE PRECISION FUNCTION S20ACF$(X, IFAIL)
C
C ACTION: Fresnel S(x) using 723
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X
      DOUBLE PRECISION DFRENS
      DOUBLE PRECISION HALF, XBIG, XSMALL
      PARAMETER (HALF = 0.5D+00, XBIG = 1.D+05, XSMALL = - XBIG)
      EXTERNAL   DFRENS
      IFAIL = 0
      IF (X.LT.XSMALL .OR. X.GT.XBIG) THEN
         S20ACF$ = HALF
      ELSE
         S20ACF$ = DFRENS(X)
      ENDIF
      END
C
C
