C
C
      DOUBLE PRECISION FUNCTION S21BBF$(X, Y, Z, IFAIL)
C
C ACTION: Elliptic function RF using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X, Y, Z
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION DRF
      EXTERNAL   DRF
      IF (X.LT.ZERO .OR. Y.LT.ZERO .OR. Z.LT.ZERO) THEN
         S21BBF$ = ZERO
         IFAIL = 1
      ELSEIF ((X + Y).LE.ZERO .OR. (X + Z).LE.ZERO .OR.
     +        (Y + Z).LE.ZERO) THEN
         S21BBF$ = ZERO
         IFAIL = 2
      ELSE
         S21BBF$ = DRF(X, Y, Z, IFAIL)
      ENDIF
      END
C
C
