C
C
      DOUBLE PRECISION FUNCTION S21BCF$(X, Y, Z, IFAIL)
C
C ACTION: Elliptic function RD using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X, Y, Z
      DOUBLE PRECISION ZERO, ZMAX, ZMIN
      PARAMETER (ZERO = 0.0D+00, ZMAX = 1.0D+200, ZMIN = 1.0D-200)
      DOUBLE PRECISION DRD
      EXTERNAL   DRD
      IF (X.LT.ZERO .OR. Y.LT.ZERO .OR. X + Y.LE.ZERO) THEN
         S21BCF$ = ZERO
         IFAIL = 1
      ELSEIF (Z.LE.ZERO) THEN
         S21BCF$ = ZERO
         IFAIL = 2
      ELSEIF (Z.LT.ZMIN) THEN
         S21BCF$ = ZERO
         IFAIL = 3
      ELSEIF (X.GT.ZMAX .OR. Y.GT.ZMAX .OR. Z.GT.ZMAX) THEN
         S21BCF$ = ZERO
         IFAIL = 4
      ELSE
         S21BCF$ = DRD(X, Y, Z, IFAIL)
      ENDIF
      END
C
C
