C
C
      DOUBLE PRECISION FUNCTION S21BDF$(X, Y, Z, R, IFAIL)
C
C ACTION: Elliptic function RJ using SLATEC
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 12/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION X, Y, Z, R
      DOUBLE PRECISION ZERO, ZMAX, ZMIN
      PARAMETER (ZERO = 0.0D+00, ZMAX = 1.0D+100, ZMIN = 1.0D-200)
      DOUBLE PRECISION DRJ
      EXTERNAL   DRJ
      INTRINSIC  MAX, MIN
      IF (MIN(X,Y,Z).LT.ZERO .OR. (X + Y).LE.ZERO .OR.
     +                            (X + Z).LE.ZERO .OR.
     +                            (Y + Z).LE.ZERO) THEN
         S21BDF$ = ZERO
         IFAIL = 1
      ELSEIF (R.LE.ZERO) THEN
         S21BDF$ = ZERO
         IFAIL = 2
      ELSEIF (R.LT.ZMIN .OR. (X.LE.ZMIN .AND. Y.LE.ZMIN) .OR.
     +                       (X.LE.ZMIN .AND. Z.LE.ZMIN) .OR.
     +                       (Y.LE.ZMIN .AND. Z.LE.ZMIN)) THEN
         S21BDF$ = ZERO
         IFAIL = 3
      ELSEIF (MAX(X,Y,Z,R) .GT. ZMAX) THEN
         S21BDF$ = ZERO
         IFAIL = 4
      ELSE
         S21BDF$ = DRJ(X, Y, Z, R, IFAIL)
         IF (IFAIL.NE.0) IFAIL = 5
      ENDIF
      END
C
C
