C
C
      SUBROUTINE S21CAF$ (U, DM, SN, CN, DN, IFAIL)
C
C ACTION: Version of S21CAF calling SNCNDN (Bulirsch algorithm)
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 14/12/2001
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION U, DM, SN, CN, DN
      DOUBLE PRECISION SQRTLM, EMMC, UU
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION X02AMF$
      EXTERNAL   X02AMF$
      EXTERNAL   SNCNDN
      INTRINSIC  ABS, SQRT
      IFAIL = 0
      SN = ZERO
      CN = ZERO
      DN = ZERO
      SQRTLM = SQRT(ONE/X02AMF$())
      IF (ABS(U).GT.SQRTLM) THEN
         IFAIL = 1
         RETURN
      ELSEIF (ABS(DM).GT.SQRTLM .AND. ABS(U).LT.ONE/SQRTLM) THEN
         IFAIL = 2
         RETURN
      ENDIF
      UU = U
      EMMC = ONE - DM
      CALL SNCNDN (UU, EMMC, SN, CN, DN)
      END
C
C
      SUBROUTINE SNCNDN (UU, EMMC, SN, CN, DN)
      IMPLICIT   NONE
      INTEGER    I, II, L
      DOUBLE PRECISION UU, EMMC, SN, CN, DN
      DOUBLE PRECISION CA
      PARAMETER (CA = 0.0003D+00)
      DOUBLE PRECISION A, B, C, D, EM(13), EMC, EN(13), U
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-300, ONE = 1.0D+00)
      LOGICAL    BO
      INTRINSIC  ABS, COS, COSH, SIN, TANH, SQRT
      EMC = EMMC
      U = UU
      IF (ABS(EMC).GE.EPSI) THEN
         BO = (EMC.LT.ZERO)
         IF (BO) THEN
            D = ONE - EMC
            EMC = -EMC/D
            D = SQRT(D)
            U = D*U
         ENDIF
         A = ONE
         DN = ONE
         DO I = 1, 13
            L = I
            EM(I) = A
            EMC = SQRT(EMC)
            EN(I) = EMC
            C = 0.5D+00*(A + EMC)
            IF (ABS(A - EMC).LE.CA*A) GOTO 20
            EMC = A*EMC
            A = C
         ENDDO
   20    CONTINUE
         U = C*U
         SN = SIN(U)
         CN = COS(U)
         IF (ABS(SN).GT.EPSI) THEN
            A = CN/SN
            C = A*C
            DO II = L, 1, -1
               B = EM(II)
               A = C*A
               C = DN*C
               DN = (EN(II) + A)/(B + A)
               A = C/B
            ENDDO
            A = ONE/SQRT(C**2 + ONE)
            IF (SN.LT.ZERO) THEN
               SN = -A
            ELSE
               SN = A
            ENDIF
            CN = C*SN
         ENDIF
         IF (BO) THEN
            A = DN
            DN = CN
            CN = A
            SN = SN/D
         ENDIF
      ELSE
         CN = ONE/COSH(U)
         DN = CN
         SN = TANH(U)
      ENDIF
      END
C
C
