C
C
      SUBROUTINE X03AAF$(A, ISIZEA, B, ISIZEB, N, ISTEPA, ISTEPB, C1,
     +                   C2, D1, D2, SW, IFAIL)
C
C ACTION: Scalar product plus constant
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 24/06/2001
C         Version of X03AAF except that all internal calculations
C         are in double precision whether SW is .TRUE. or .FALSE.
C         Also there is no error reporting mechanism.
C
C         NOTE: all real arguments must be in double precision.
C         =====                    ====
C
      IMPLICIT  NONE
      INTEGER   IFAIL, ISIZEA, ISIZEB, ISTEPA, ISTEPB, N
      INTEGER   I, IS, IT
      DOUBLE PRECISION C1, C2, D1, D2
      DOUBLE PRECISION A(ISIZEA), B(ISIZEB)
      DOUBLE PRECISION SUM1
      DOUBLE PRECISION X
      LOGICAL   SW
      INTRINSIC DBLE, REAL
C
C Check dimensions
C
      IF (ISTEPA.LE.0 .OR. ISTEPB.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (ISIZEA.LE.(N-1)*ISTEPA .OR. ISIZEB.LE.(N-1)*ISTEPB) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IS = 1 - ISTEPA
      IT = 1 - ISTEPB
      IF (.NOT.SW) THEN
C
C SW = .FALSE. (except that calculations are in double precision)
C
         X = 0.0D+00
         IF (N.GE.1) THEN
            DO I = 1, N
               IS = IS + ISTEPA
               IT = IT + ISTEPB
               X = X + A(IS)*B(IT)
            ENDDO
         ENDIF
         D1 = X + (C1 + C2)
         D2 = 0.0D+00
         IFAIL = 0
         RETURN
      ELSE
C
C SW = .TRUE.
C
         SUM1 = 0.0D0
         IF (N.GE.1) THEN
            DO I = 1, N
               IS = IS + ISTEPA
               IT = IT + ISTEPB
               SUM1 = SUM1 + A(IS)*B(IT)
            ENDDO
         ENDIF
         SUM1 = SUM1 + (C1 + C2)
         D1 = SUM1 + SUM1 - DBLE(REAL(SUM1))
         D2 = SUM1 - D1
         IFAIL = 0
         RETURN
      ENDIF
      END
C
C
