c
c
      subroutine incomp (method, ncmax, ngrp, nobs, nmax,
     +                   x, y,   
     +                   fname, fsav, tsav, 
     +                   abort)
c
c action: use w_incomp to read vectors off an incomplete matrix file
c author: w.g.bardsley, university of manchester, u.k., 21/08/2016
c     
c method: 0 (help), 1(read in a file)
c  ncmax: maximum number of columns, i.e. groups
c   ngrp: number of groups, i.e. files returned
c   nobs: number of observations per group
c   nmax: maximum sum of nobs, i.e. vector lengths
c      x: workspace
c      y: sorted concatenation of vectors
c  fname: name of incomplete matrix file
c   fsav: name of file returned
c   tsav: titles of files returned 
c  abort: success indicator
c 
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: method, ncmax, nmax
      integer,             intent (out) :: ngrp, nobs(ncmax) 
      double precision,    intent (out) :: x(nmax), y(nmax)
      character (len = *), intent (out) :: fname, fsav(ncmax),
     +                                     tsav(ncmax)
      logical,             intent (out) :: abort
c
c locals
c      
      external w_incomp 
      call w_incomp (method, ncmax, ngrp, nobs, nmax,
     +               x, y,   
     +               fname, fsav, tsav, 
     +               abort)
      end
c
c        