C
C
      SUBROUTINE ADDSTR (FNAME, STRNG)
C
C ACTION: Add a string to the end of a text file if possible
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 1/7/97
C         04/01/2001 removed GOTO, added REPEET 
C         01/12/2006 edited and increased TEXT*129 to TEXT*256 
C         18/01/2011 increased TEXT*256 to TEXT*1024 
C
      IMPLICIT   NONE  
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (IN) :: FNAME, STRNG      
C
C Locals
C      
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    IOS, NOUT
      CHARACTER  TEXT*1024
      LOGICAL    THERE, READ_ONLY, REPEET
      EXTERNAL   GETNOU, ATTRIB
C
C Does the file exist ?
C                                  
      TEXT = FNAME       !to stop NAGfor complaining
      CALL ATTRIB (TEXT, !to stop NAGfor complaining
     +             THERE, READ_ONLY)   
      IF (.NOT.THERE .OR. READ_ONLY) RETURN
C
C Find a unit
C
      CALL GETNOU (NOUT)
      IF (NOUT.LT.N0) RETURN
C
C Open the file
C
      OPEN (UNIT = NOUT, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF  
C
C Add the string to the end of the file
C      
      REPEET = .TRUE.
      DO WHILE (REPEET)
         READ (NOUT,'(A)',IOSTAT=IOS) TEXT
         IF (IOS.LT.N0) THEN
            BACKSPACE (NOUT, IOSTAT = IOS)
            WRITE (NOUT,'(A)',IOSTAT=IOS) STRNG
            REPEET = .FALSE.
         ENDIF
      ENDDO
      CLOSE (UNIT = NOUT)              
      END
C
C
