c
c
      subroutine attrib (fname,
     +                   exist, read_only)
c
c action: see if fname exists and is read_only 
c author: w.g.bardsley, university of manchester, u.k., 06/12/2006 
c         28/01/2007 derived from previous attrib 
c         19/04/2014 idea using open by David Bailey but using action from inquire   
c         17/12/2019 now uses BTEST to check the attribute bit for read_only
c
c     fname: (input/unchanged) file name
c     exist: (output) .true. if file exists
c read_only: (output) .true. if file exists and is read only
c
      implicit  none
c
c arguments
c          
      character (len = *), intent (in)  :: fname
      logical,             intent (out) :: exist, read_only
c
c locals
c      
      integer    i, ios, get_file_attributes, pos
      parameter (pos = 0)
      logical    ex
      external   get_file_attributes
      intrinsic  btest   
c
c initialise exist and read_only to .false. then inquire
c         
      exist = .false.                     
      read_only = .false.
      inquire (file = fname, exist = ex, iostat = ios)
c
c if file exists and is not connected then check the read_only attribute
c
      if (ios.eq.0 .and. ex) then
         exist = .true.
         i = get_file_attributes (fname)
         read_only = btest(i,pos)
      endif
      end
c
c                                                                                                 