c
c
      subroutine checkf (fname, title,
     +                   abort)
c
c action: check if file/title supplied is/are OK
c author: w.g.bardsley, university of manchester, u/k/, 04/02/2005
c         21/02/2007 added intents
c         30/04/2011 added call to nklcfg
c         30/08/2015 added call to switch
c
c         fname: (input/unchanged) file name
c         title: (input/unchanged) data title
c         abort: (output) accept or reject the file and/or title
c
c Note: demo files are not checked nor are users files if advanced
c       option kval(7) = item(31) is switched off, i.e. = 0
c       if the file is the demo file for the procedure the choice is not offered 
c
      implicit   none
c
c arguments
c
      character (len = *), intent (in)  :: fname, title
      logical,             intent (out) :: abort
c
c locals
c
      integer    icolor, ios, isend, numdec, numhdr, numopt, n19, n31
      parameter (icolor = 7, isend = 1, numhdr = 15, numopt = 4,
     +           n19 = 19, n31 = 31)
      integer    numbld(numhdr), numpos(numopt)
      integer    kval7, nklcfg
      character (len = 100) headr(numhdr)
      character (len = 80 ) chop80, trim80
      character (len = 80 ) fname1, title1
      character (len = 20 ) optn(numopt)
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    done, op, repeet, there
      logical    demo, store
      parameter (store = .false.)
      external   nklcfg, switch
      external   checkt, title2, chop80, trim80, viewer, demsav, putadv
      data       numbld / 4, 0, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0 /
      data       numpos / 1, 1, 1, 1 /
c
c initialise abort then see if control is switched on (by ADVANCED OPTION 7)
c
      abort = .false.
      done = .false.
      kval7 = nklcfg(n19)
      if (kval7.ne.1) return
c
c see if the file exists
c
      inquire (file = fname, exist = there, iostat = ios, opened = op)
      if (ios.eq.0 .and. there .and. .not.op) then
         call demsav (demo, store)
         if (demo) return
c
c provide the option to view/open/cancel for this file
c
         fname1 = trim80(fname)
         title1 = chop80(title)
         write (headr,100) fname1, title1
         write (optn,200)
         repeet = .true.
         do while (repeet)
            numdec = 1
            call title2 (icolor, numbld, numdec, numhdr, numopt,
     +                   numpos,
     +                   headr, optn)
            if (numdec.eq.1) then
c
c view
c
               call viewer (isend,
     +                      fname, blank, blank)
            elseif (numdec.eq.2) then
c
c open
c
               abort = .false.
               repeet = .false.
            elseif (numdec.eq.3) then
c
c cancel
c
               abort = .true.
               repeet = .false.
            else
               if (done) then
                  call putadv ('This has already been implemented')
               else
                  call switch (n31)
                  done = .true.
               endif   
            endif
         enddo
      else
c
c file does not exist so just query the title
c
         call checkt (title,
     +                abort)
      endif
c
c format statements
c      
  100 format (
     + 'View, Open, or Cancel a selected file.'
     +/
     +/'To switch this option on/off use [Configure],[Advanced],',
     +'[Speedup].'
     +/
     +/'A potential data file has been located, and you now have the'
     +/'opportunity to check that this is formatted correctly, and is'
     +/'the intended data set before proceeding to analysis.'
     +/
     +/'The name of the data file selected for analysis is:'
     +/A
     +/
     +/'The title of this data set is:'
     +/A
     +/
     +/'To prevent these options appearing again choose [Suppress].')
  200 format (
     + 'View'
     +/'Open'
     +/'Cancel'
     +/'Suppress')
      end
c
c
