C
C
      SUBROUTINE CHKDAT (NPTS,
     +                   S, X, Y,
     +                   CIPHER,
     +                   OK, READY)
C
C ACTION : Check data for consistency
C          Calculation of NDIST and NOREPS requires X to be sorted
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          23/02/1994 DBOS version
C          16/02/1997 Win32 version (removed % from original)
C          27/09/2002 relaced patch1 by table1
C          21/02/2007 added INTENTS
C          24/09/2021 added FORM15 and FORM12
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NPTS 
      DOUBLE PRECISION,    INTENT (IN)  :: S(NPTS), X(NPTS), Y(NPTS)
      CHARACTER (LEN = *), INTENT (OUT) :: CIPHER(2,NPTS)
      LOGICAL,             INTENT (OUT) :: OK, READY 
C
C Locals
C       
      INTEGER    I, J
      INTEGER    NABOVE, NBELOW, NDIST, NOCVPC, NOREPS, NWRONG
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 19)
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION EPSI, XSMALL
      DOUBLE PRECISION X02AJFG, X02AMFG
      DOUBLE PRECISION PNT01, PNT5
      PARAMETER (PNT01 = 0.01D+00, PNT5 = 0.5D+00)
      DOUBLE PRECISION VBIG, VSMALL
      PARAMETER (VBIG = 1.0D+10, VSMALL = 1.0D-10)
      DOUBLE PRECISION ABSXI, ABSYI, RELERR, XPREV, XREPS
      DOUBLE PRECISION SMAX, SMIN, XMAX, XMIN, YMAX, YMIN
      CHARACTER  (LEN = 12) FORM12, NABOVE_12, NBELOW_12, NDIST_12,
     +                      NOCVPC_12, NOREPS_12, NPTS_12, NWRONG_12
      CHARACTER  (LEN = 15) FORM15, XMAX15, XMIN15, YMAX15, YMIN15
      CHARACTER  ARROW*4, BLANK*4
      PARAMETER (ARROW = '****', BLANK = ' ')
      CHARACTER  BOTH*54, TYPE1*52, XWARN*52, YWARN*52
      CHARACTER  CABOVE*4, CBELOW*4, COCVPC*4, CWRONG*4, CX*4, CY*4
      CHARACTER  TEXT(NUMTXT)*100
      LOGICAL    WEIGHT
      EXTERNAL   FORM12, FORM15	
      EXTERNAL   PUTBEL, TESTER, TABLE1
      EXTERNAL   X02AJFG, X02AMFG
      INTRINSIC  ABS, MAX, SQRT, TRIM
C
C Initialise
C
      EPSI = TWO*X02AJFG()
      XSMALL = SQRT(X02AMFG())
C
C First make sure S is positive
C
      I = NPTS
      J = NPTS
      CALL TESTER (S, I, J, XSMALL)
C
C Now see if all S = 1
C
      SMAX = ONE + EPSI
      SMIN = ONE - EPSI
      WEIGHT = .FALSE.
      I = 0
      DO WHILE (I.LT.NPTS .AND. .NOT.WEIGHT)
         I = I + 1
         IF (S(I).LT.SMIN .OR. S(I).GT.SMAX) WEIGHT = .TRUE.
      ENDDO
C
C Check the data for consistency
C
      J = 0
      NABOVE = 0
      NBELOW = 0
      NDIST = 1
      NOCVPC = 0
      NOREPS = 0
      NWRONG = 0
      XMAX = X(1)
      XMIN = X(1)
      XPREV = X(1)
      XREPS = X(1)
      YMAX = Y(1)
      YMIN = Y(1)
      DO I = 1, NPTS
         CIPHER(1,I) = BLANK
         CIPHER(2,I) = BLANK
         IF (WEIGHT) THEN
            ABSYI = ABS(Y(I))
            IF (ABSYI.GT.XSMALL) THEN
               RELERR = S(I)/ABSYI
               IF (RELERR.LT.PNT01) THEN
                  NBELOW = NBELOW + 1
                  CIPHER(1,I) = 's<.01y'
               ELSEIF (RELERR.GT.PNT5) THEN
                  NABOVE = NABOVE + 1
                  CIPHER(1,I) = 's>.50y'
               ENDIF
            ELSE
               NOCVPC = NOCVPC + 1
               CIPHER(1,I) = 's/y=??'
            ENDIF
         ENDIF
         IF (X(I).LT.XPREV) THEN
            NWRONG = NWRONG + 1
            CIPHER(2,I) = 'x down'
         ENDIF
         IF (X(I).GT.XREPS) THEN
            IF (J.EQ.1) THEN
               NOREPS = NOREPS + 1
               IF (I.EQ.NPTS) NOREPS = NOREPS + 1
            ENDIF
            J = 1
            NDIST = NDIST + 1
            XREPS = X(I)
         ELSE
           J = J + 1
         ENDIF
         IF (X(I).GT.XMAX) XMAX = X(I)
         IF (X(I).LT.XMIN) XMIN = X(I)
         IF (Y(I).GT.YMAX) YMAX = Y(I)
         IF (Y(I).LT.YMIN) YMIN = Y(I)
         XPREV = X(I)
      ENDDO
      XMAX15 = FORM15(XMAX)
      XMIN15 = FORM15(XMIN)
      YMAX15 = FORM15(YMAX)
      YMIN15 = FORM15(YMIN)
C
C Set warning indicators
C
      OK = .TRUE.
      READY = .TRUE.
      IF (NWRONG.GT.0) THEN
         OK = .FALSE.
         READY = .FALSE.
         CWRONG = ARROW
      ELSE
         CWRONG = BLANK
      ENDIF
      IF (NOCVPC.GT.0) THEN
         OK = .FALSE.
         COCVPC = ARROW
      ELSE
         COCVPC = BLANK
      ENDIF
      IF (NBELOW.GT.0) THEN
         OK = .FALSE.
         CBELOW = ARROW
      ELSE
         CBELOW = BLANK
      ENDIF
      IF (NABOVE.GT.0) THEN
         OK = .FALSE.
         CABOVE = ARROW
      ELSE
         CABOVE = BLANK
      ENDIF
      ABSXI = MAX(ABS(XMAX), ABS(XMIN))
      IF (ABSXI.LT.VSMALL) THEN
         XWARN = 'The x-values are rather small ... choose new units ?'
         CX = ARROW
         OK = .FALSE.
      ELSEIF (ABSXI.GT.VBIG) THEN
         XWARN = 'The x-values are rather large ... choose new units ?'
         CX = ARROW
         OK = .FALSE.
      ELSE
         XWARN = BLANK
         CX = BLANK
      ENDIF
      ABSYI = MAX(ABS(YMAX), ABS(YMIN))
      IF (ABSYI.LT.VSMALL) THEN
         YWARN = 'The y-values are rather small ... choose new units ?'
         CY = ARROW
         OK = .FALSE.
      ELSEIF (ABSYI.GT.VBIG) THEN
         YWARN = 'The y-values are rather large ... choose new units ?'
         CY = ARROW
         OK = .FALSE.
      ELSE
         YWARN = BLANK
         CY = BLANK
      ENDIF
      IF (WEIGHT) THEN
         TYPE1 = 'Data file is now ready for weighted curve-fitting'
      ELSE
         TYPE1 = 'Data file is now ready for unweighted curve-fitting'
      ENDIF
      BOTH = 'but there may be some points to attend to as follows'
      DO I = 1, NUMTXT
         TEXT(I) = ' '
      ENDDO
      NPTS_12 = FORM12(NPTS)
      NDIST_12 = FORM12(NDIST)
      NOREPS_12 = FORM12(NOREPS) 
      NWRONG_12 = FORM12(NWRONG)
      NOCVPC_12 = FORM12(NOCVPC)
      NBELOW_12 = FORM12(NBELOW)
      NABOVE_12 = FORM12(NABOVE)
      IF (.NOT.READY) THEN
         CALL PUTBEL
         WRITE (TEXT,100) XMIN15, XMAX15, YMIN15, YMAX15, NPTS_12,
     +                    TRIM(NWRONG_12), CWRONG, XWARN, YWARN
         ICOLOR = 15
         CALL TABLE1 (ICOLOR, 'OPEN')
         DO I = 1, NUMTXT
            IF (I.EQ.7) THEN
               ICOLOR = 4
            ELSEIF (I.EQ.(NUMTXT - 1) .OR. I.EQ.NUMTXT) THEN
               ICOLOR = 1
            ELSE
               ICOLOR = 0
            ENDIF
            CALL TABLE1 (ICOLOR, TEXT(I))
         ENDDO
         CALL TABLE1 (ICOLOR, 'CLOSE')
      ELSEIF (.NOT.OK) THEN
         CALL PUTBEL
         IF (WEIGHT) THEN
            WRITE (TEXT,200) TYPE1, BOTH, XMIN15, XMAX15, YMIN15,
     +                       YMAX15, NPTS_12,
     +                       NDIST_12, NOREPS_12, TRIM(NWRONG_12),
     +                       CWRONG, TRIM(NOCVPC_12), COCVPC,
     +                       TRIM(NBELOW_12), CBELOW,
     +                       TRIM(NABOVE_12), CABOVE,
     +                       XWARN, CX, YWARN, CY
            ICOLOR = 15
            CALL TABLE1 (ICOLOR, 'OPEN')
            DO I = 1, NUMTXT
               IF (I.EQ.4) THEN
                  ICOLOR = 4
               ELSEIF (I.EQ.(NUMTXT - 1) .OR. I.EQ.NUMTXT) THEN
                  ICOLOR = 1
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ELSE
            WRITE (TEXT,300) TYPE1, BOTH, XMIN15, XMAX15, YMIN15,
     +                       YMAX15, NPTS_12,
     +                       NDIST_12, NOREPS_12, TRIM(NWRONG_12),
     +                       CWRONG, XWARN, CX, YWARN, CY
            ICOLOR = 15
            CALL TABLE1 (ICOLOR, 'OPEN')
            DO I = 1, NUMTXT
               IF (I.EQ.4) THEN
                  ICOLOR = 4
               ELSEIF (I.EQ.(NUMTXT - 1) .OR. I.EQ.NUMTXT) THEN
                  ICOLOR = 1
               ELSE
                  ICOLOR = 0
               ENDIF
               CALL TABLE1 (ICOLOR, TEXT(I))
            ENDDO
            CALL TABLE1 (ICOLOR, 'CLOSE')
         ENDIF
      ENDIF
  100 FORMAT (
     + 'Fatal*: The data file is not yet ready for input to the'
     +/'        SIMFIT curve-fitting programs because the data'
     +/'        points are not in order of increasing x.'
     +/
     +/'Advice: Edit data points indicated when table is displayed'
     +/
     +/'Analysis of current x, y data'
     +/
     +/'Smallest x-value     =',1X,A
     +/'Largest  x-value     =',1X,A
     +/'Smallest y-value     =',1X,A
     +/'Largest  y-value     =',1X,A
     +/'Number of x, y pairs =',1X,A12
     +/'Number out of order  =',1X,A,1X,A
     +/A
     +/A
     +/
     +/'Symbols will identify suspect data points when the table'
     +/'of current x, y, s is displayed (indicated as x down).')
  200 FORMAT (
     + A
     +/A
     +/
     +/'Analysis of current x, y, s data'
     +/'Smallest x-value                                 =',1X,A
     +/'Largest  x-value                                 =',1X,A
     +/'Smallest y-value                                 =',1X,A
     +/'Largest  y-value                                 =',1X,A
     +/'Total number of data points                      =',1X,A12
     +/'Number of distinct x-values                      =',1X,A12
     +/'Number of x-values with no replicates            =',1X,A12
     +/'Number of decreasing x-values   (i.e. x down)    =',1X,A,1X,A
     +/'Number of s/y ratios not defined(i.e. s/y=??)    =',1X,A,1X,A
     +/'Number of points where s < 0.01|y| (i.e. s<.01y) =',1X,A,1X,A
     +/'Number of points where s > 0.50|y| (i.e. s>.50y) =',1X,A,1X,A
     +/A52,3X,A
     +/A52,3X,A
     +/'Symbols will identify any suspect data points when the'
     +/'table of current x, y, s is displayed.')
  300 FORMAT (
     + A
     +/A
     +/
     +/'Analysis of current x, y data'
     +/'Smallest x-value                      =',1X,A
     +/'Largest  x-value                      =',1X,A
     +/'Smallest y-value                      =',1X,A
     +/'Largest  y-value                      =',1X,A
     +/'Total number of data points           =',1X,A12
     +/'Number of distinct x-values           =',1X,A12
     +/'Number of x-values with no replicates =',1X,A12
     +/'Number of decreasing x-values         =',1X,A,1X,A
     +/A52,3X,A
     +/A52,3X,A
     +/
     +/
     +/'Symbols will identify any suspect data points when the'
     +/'table of current x, y, s is displayed.')
      END
C
C
